/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.opf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    COVER(1, "Cover", "cover"),
    TITLE(2, "Title", "title-page"),
    TOC(3, "TOC", "toc"),
    INDEX(4, "Index", "index"),
    GLOSSARY(5, "Glossary", "glossary"),
    ACKNOWLEDGEMENTS(6, "Acknowledgements", "acknowledgements"),
    BIBLIOGRAPHY(7, "Bibliography", "bibliography"),
    COLOPHON(8, "Colophon", "colophon"),
    COPYRIGHT(9, "Copyright", "copyright-page"),
    DEDICATION(10, "Dedication", "dedication"),
    EPIGRAPH(11, "Epigraph", "epigraph"),
    FOREWORD(12, "Foreword", "foreword"),
    ILLUSTRATIONS(13, "Illustrations", "loi"),
    TABLES(14, "Tables", "lot"),
    NOTES(15, "Notes", "notes"),
    PREFACE(16, "Preface", "preface"),
    TEXT(17, "Text", "text");

    public static final int COVER_VALUE = 1;
    public static final int TITLE_VALUE = 2;
    public static final int TOC_VALUE = 3;
    public static final int INDEX_VALUE = 4;
    public static final int GLOSSARY_VALUE = 5;
    public static final int ACKNOWLEDGEMENTS_VALUE = 6;
    public static final int BIBLIOGRAPHY_VALUE = 7;
    public static final int COLOPHON_VALUE = 8;
    public static final int COPYRIGHT_VALUE = 9;
    public static final int DEDICATION_VALUE = 10;
    public static final int EPIGRAPH_VALUE = 11;
    public static final int FOREWORD_VALUE = 12;
    public static final int ILLUSTRATIONS_VALUE = 13;
    public static final int TABLES_VALUE = 14;
    public static final int NOTES_VALUE = 15;
    public static final int PREFACE_VALUE = 16;
    public static final int TEXT_VALUE = 17;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Type get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Type result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Type getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Type result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 1: {
                return COVER;
            }
            case 2: {
                return TITLE;
            }
            case 3: {
                return TOC;
            }
            case 4: {
                return INDEX;
            }
            case 5: {
                return GLOSSARY;
            }
            case 6: {
                return ACKNOWLEDGEMENTS;
            }
            case 7: {
                return BIBLIOGRAPHY;
            }
            case 8: {
                return COLOPHON;
            }
            case 9: {
                return COPYRIGHT;
            }
            case 10: {
                return DEDICATION;
            }
            case 11: {
                return EPIGRAPH;
            }
            case 12: {
                return FOREWORD;
            }
            case 13: {
                return ILLUSTRATIONS;
            }
            case 14: {
                return TABLES;
            }
            case 15: {
                return NOTES;
            }
            case 16: {
                return PREFACE;
            }
            case 17: {
                return TEXT;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Type[]{COVER, TITLE, TOC, INDEX, GLOSSARY, ACKNOWLEDGEMENTS, BIBLIOGRAPHY, COLOPHON, COPYRIGHT, DEDICATION, EPIGRAPH, FOREWORD, ILLUSTRATIONS, TABLES, NOTES, PREFACE, TEXT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

