/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.detachable.ArrayReference;
import org.eclipse.xtext.nodemodel.detachable.DetachableNodeModelBuilder;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.NodeModelInput;
import org.eclipse.xtext.util.Strings;

public class CompactStoredNodeModelReader
extends BinaryResourceImpl.EObjectInputStream
implements NodeModelInput {
    private final Tabulated<ArrayReference> grammarElementArrays;
    private final Tabulated<EObject> semanticObjects;
    private final Tabulated<SyntaxErrorMessage> syntaxErrorMessages;
    private final DetachableNodeModelBuilder nodeModelBuilder;
    private final String content;
    private final GrammarElementLookup grammarElements;
    private int offset;

    public CompactStoredNodeModelReader(InputStream inputStream, String content, Tabulated<EObject> semanticObjects, DetachableNodeModelBuilder nodeModelBuilder, GrammarElementLookup grammarElements) throws IOException {
        super(inputStream, Collections.singletonMap("INTERNAL_BUFFER_CAPACITY", 8192));
        this.content = content;
        this.semanticObjects = semanticObjects;
        this.nodeModelBuilder = nodeModelBuilder;
        this.grammarElements = grammarElements;
        this.syntaxErrorMessages = new Tabulated();
        this.grammarElementArrays = new Tabulated();
    }

    @Override
    public AbstractNode readNode(int type) throws IOException {
        AbstractNode result = NodeModelInput.super.readNode(type);
        if (result instanceof CompositeNodeWithSemanticElement && result.hasDirectSemanticElement()) {
            this.nodeModelBuilder.associateWithSemanticElement((ICompositeNode)((Object)result), result.getSemanticElement());
        }
        return result;
    }

    protected void readSignature() throws IOException {
    }

    @Override
    public int readLength() throws IOException {
        int result = this.readCompressedInt();
        this.offset += result;
        return result;
    }

    @Override
    public int currentOffset() {
        return this.offset;
    }

    @Override
    public Object readGrammarElement() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        if (id >= this.grammarElements.size()) {
            EObject[] array;
            if ((id -= this.grammarElements.size()) == this.grammarElementArrays.size()) {
                int len = this.readCompressedInt();
                array = new EObject[len];
                int i = 0;
                while (i < len) {
                    array[i] = this.grammarElements.getGrammarElement(this.readCompressedInt());
                    ++i;
                }
                this.grammarElementArrays.getId(new ArrayReference(array));
            } else {
                array = this.grammarElementArrays.getObject(id).getArray();
            }
            return array;
        }
        return this.grammarElements.getGrammarElement(id);
    }

    @Override
    public EObject readSemanticObject() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        return this.semanticObjects.getObject(id);
    }

    @Override
    public SyntaxErrorMessage readSyntaxErrorMessage() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        if (id == this.syntaxErrorMessages.size()) {
            String[] issueData;
            String issueCode = this.readSegmentedString();
            String message = this.readSegmentedString();
            int issueDataLen = this.readCompressedInt();
            if (issueDataLen == -1) {
                issueData = null;
            } else if (issueDataLen == 0) {
                issueData = Strings.EMPTY_ARRAY;
            } else {
                issueData = new String[issueDataLen];
                int i = 0;
                while (i < issueDataLen) {
                    issueData[i] = this.readSegmentedString();
                    ++i;
                }
            }
            SyntaxErrorMessage result = new SyntaxErrorMessage(message, issueCode, issueData);
            this.syntaxErrorMessages.getId(result);
            return result;
        }
        return this.syntaxErrorMessages.getObject(id);
    }

    protected boolean hasErrors() {
        return this.syntaxErrorMessages.size() > 0;
    }

    @Override
    public String readContent() throws IOException {
        return this.content;
    }
}

