/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ConditionUtils {
    public static void notRemoved(EObject object, String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(" cannot be null");
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)_builder);
        Resource _eResource = object.eResource();
        boolean _tripleNotEquals = _eResource != null;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(name);
        _builder_1.append(" cannot be removed");
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)_builder_1);
    }

    public static void checkInferredTypeReferences(String typeName, TypeReference ... types) {
        TypeReference[] typeReferenceArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference type = typeReferenceArray[n2];
            if (type != null && type.isInferred()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot use inferred type as ");
                _builder.append(typeName);
                _builder.append(".");
                throw new IllegalArgumentException(_builder.toString());
            }
            ++n2;
        }
    }

    public static void checkIterable(Iterable<?> values, String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(" cannot be null");
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)_builder);
        for (Object value : values) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(name);
            _builder_1.append(" cannot contain null");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)_builder_1);
        }
    }

    public static void checkQualifiedName(String qualifiedName, String name) {
        boolean _isValidQualifiedName = ConditionUtils.isValidQualifiedName(qualifiedName);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(" has to be a valid qualified name");
        Preconditions.checkArgument((boolean)_isValidQualifiedName, (Object)_builder);
    }

    public static void checkJavaIdentifier(String string, String name) {
        boolean _isValidJavaIdentifier = ConditionUtils.isValidJavaIdentifier(string);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(" has to be a valid java identifier");
        Preconditions.checkArgument((boolean)_isValidJavaIdentifier, (Object)_builder);
    }

    public static void checkTypeName(String typeName, String valueType) {
        boolean _equals = Objects.equals(typeName, valueType);
        Preconditions.checkArgument((boolean)_equals, (Object)ConditionUtils.isNotApplicableMessage(valueType, typeName));
    }

    public static String isNotApplicableMessage(String valueType, String typeName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(valueType);
        _builder.append(" is not applicable at this location. Expected ");
        _builder.append(typeName);
        return _builder.toString();
    }

    public static boolean isValidQualifiedName(String string) {
        String[] _split;
        boolean _xblockexpression = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = _split = string.split("\\.");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            String identifier = stringArray[n2];
            boolean _isValidJavaIdentifier = ConditionUtils.isValidJavaIdentifier(identifier);
            boolean bl = _not = !_isValidJavaIdentifier;
            if (_not) {
                return false;
            }
            ++n2;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public static boolean isValidJavaIdentifier(String string) {
        boolean _not;
        boolean _xblockexpression = false;
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] charArray = string.toCharArray();
        boolean _isJavaIdentifierStart = Character.isJavaIdentifierStart(((Character)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)charArray)))).charValue());
        boolean bl = _not = !_isJavaIdentifierStart;
        if (_not) {
            return false;
        }
        Iterable _tail = IterableExtensions.tail((Iterable)((Iterable)Conversions.doWrapArray((Object)charArray)));
        for (Character ch : _tail) {
            boolean _not_1;
            boolean _isJavaIdentifierPart = Character.isJavaIdentifierPart(ch.charValue());
            boolean bl2 = _not_1 = !_isJavaIdentifierPart;
            if (!_not_1) continue;
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }
}

