/**
 * Copyright (c) 2002-2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 */
package org.eclipse.emf.edit.command;


import java.util.Collection;


/**
 * This interface is implemented by any {@link org.eclipse.emf.common.command.Command} that supports detailed drag and drop feedback.
 * This interface provides synonyms for all the important org.eclipse.swt.dnd.DND constants,
 * so that commands can be written without reference to SWT.
 */
public interface DragAndDropFeedback
{
  /**
   * This is the same as org.eclipse.swt.dnd.DND.DROP_NONE.
   */
  public final static int DROP_NONE = 0;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.DROP_COPY.
   */
  public final static int DROP_COPY = 1;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.DROP_MOVE.
   */
  public final static int DROP_MOVE = 2;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.DROP_LINK.
   */
  public final static int DROP_LINK = 4;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.FEEDBACK_NONE.
   */
  public final static int FEEDBACK_NONE = 0;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.FEEDBACK_SELECT.
   */
  public final static int FEEDBACK_SELECT = 1;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.FEEDBACK_INSERT_BEFORE.
   */
  public final static int FEEDBACK_INSERT_BEFORE = 2;

  /**
   * This is the same as org.eclipse.swt.dnd.DND.FEEDBACK_INSERT_AFTER.
   */
  public final static int FEEDBACK_INSERT_AFTER = 4;

  /**
   * This is called repeatedly as the drag and drop information changes.
   * The collection, which represents the dragged source, does not normally change.
   */
  public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection);

  /**
   * This returns one of the FEEDBACK_* values.
   */
  public int getFeedback();

  /**
   * This returns one of the DROP_* values.
   */
  public int getOperation();
}
