/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.create.arcas;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.uml2.diagram.sequence.edit.create.arcas.AnchorUtil;

public class AnchoredDiagramTarget {
    private GraphicalEditPart myContainer;
    private GraphicalEditPart myAnchor;
    private boolean myIsBeforeAnchor = false;

    public AnchoredDiagramTarget(GraphicalEditPart container, GraphicalEditPart anchor, boolean before) {
        if (container == null) {
            throw new IllegalArgumentException("container mustn't be null.");
        }
        this.myContainer = container;
        this.myAnchor = anchor;
        this.myIsBeforeAnchor = before;
    }

    public AnchoredDiagramTarget(GraphicalEditPart container) {
        this(container, null, true);
    }

    public AnchoredDiagramTarget(GraphicalEditPart container, Request request) {
        this.myContainer = container;
        this.myAnchor = AnchorUtil.getAnchor(request);
        this.myIsBeforeAnchor = AnchorUtil.isBeforeAnchor(request);
    }

    public GraphicalEditPart getContainer() {
        return this.myContainer;
    }

    public GraphicalEditPart getAnchor() {
        return this.myAnchor;
    }

    public EObject getSemanticContainer() {
        return this.myContainer.resolveSemanticElement();
    }

    public EObject getSemanticAnchor() {
        return this.myAnchor == null ? null : this.myAnchor.resolveSemanticElement();
    }

    public boolean isBeforeAnchor() {
        return this.myIsBeforeAnchor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnchoredDiagramTarget)) {
            return false;
        }
        AnchoredDiagramTarget target = (AnchoredDiagramTarget)o;
        if (this.myAnchor == null && target.myAnchor != null) {
            return false;
        }
        if (this.myAnchor != null && !this.myAnchor.equals(target.myAnchor)) {
            return false;
        }
        if (this.myAnchor != null && this.myIsBeforeAnchor != target.myIsBeforeAnchor) {
            return false;
        }
        if (this.myContainer == null && target.myContainer != null) {
            return false;
        }
        return this.myContainer == null || this.myContainer.equals(target.myContainer);
    }

    public int hashCode() {
        return AnchoredDiagramTarget.hash(this.myContainer) + AnchoredDiagramTarget.hash(this.myAnchor) + (this.myIsBeforeAnchor ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode());
    }

    public boolean checkSemantic() {
        EObject semanticContainer = this.myContainer.resolveSemanticElement();
        if (semanticContainer == null) {
            return false;
        }
        if (this.myAnchor != null) {
            EObject semanticAnchor = this.myAnchor.resolveSemanticElement();
            if (semanticAnchor == null) {
                return false;
            }
            if (!EcoreUtil.isAncestor((EObject)semanticContainer, (EObject)semanticAnchor)) {
                return false;
            }
        }
        return true;
    }

    private static int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static AnchoredDiagramTarget createTarget(EditPart part, Request request) {
        if (part instanceof GraphicalEditPart) {
            return new AnchoredDiagramTarget((GraphicalEditPart)part, request);
        }
        return null;
    }
}

