/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.csd.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.conventions.ConnectorEndConvention;
import org.eclipse.uml2.diagram.csd.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.csd.part.UMLLinkDescriptor;
import org.eclipse.uml2.diagram.csd.part.UMLNodeDescriptor;
import org.eclipse.uml2.diagram.csd.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;

    public void activate() {
        super.activate();
        this.addListenerFilter("NotationListener_Container" + this.getDiagram().toString(), (NotificationListener)this, (EObject)this.getDiagram(), (EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren());
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = UMLDiagramUpdater.getSemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((UMLNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        int actualID = UMLVisualIDRegistry.getVisualID(view);
        int suggestedID = UMLVisualIDRegistry.getNodeVisualID((View)this.getHost().getModel(), view.getElement());
        switch (actualID) {
            case 2003: 
            case 2005: 
            case 2009: 
            case 2011: 
            case 2012: {
                return !semanticChildren.contains(view.getElement()) || actualID != suggestedID;
            }
            case 2006: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2007;
            }
            case 2007: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return actualID != suggestedID && suggestedID != 2006;
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        return this.refreshConnectionsGen();
    }

    private Collection refreshConnectionsGen() {
        Domain2Notation domain2NotationMap = new Domain2Notation();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Domain2Notation domain2NotationMap) {
        if (!"UMLCompositeStructures".equals(UMLVisualIDRegistry.getModelID(view))) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCollaboration_2005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_2006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_2007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterface_2009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInstanceSpecification_2011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_2012ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCollaborationUse_3002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getParameter_3013ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_3010ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPort_3011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getElementImport_3004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3014ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPort_3016ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getSlot_3015ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConnector_4005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDependency_4006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterfaceRealization_4007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUsage_4008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociation_4011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Domain2Notation domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (UMLLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
            EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private EditPart getSourceEditPartGen(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getSource(), domain2NotationMap);
    }

    private EditPart getSourceEditPart(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        if (4005 == descriptor.getVisualID() && ConnectorEndConvention.getSourceEnd((Connector)((Connector)descriptor.getModelElement())).getPartWithPort() != null) {
            return this.getHintedChildEditPart((EObject)ConnectorEndConvention.getSourceEnd((Connector)((Connector)descriptor.getModelElement())).getPartWithPort(), descriptor.getSource(), domain2NotationMap, 3016);
        }
        return this.getSourceEditPartGen(descriptor, domain2NotationMap);
    }

    private EditPart getTargetEditPartGen(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
    }

    private EditPart getTargetEditPart(UMLLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        if (4005 == descriptor.getVisualID() && ConnectorEndConvention.getTargetEnd((Connector)((Connector)descriptor.getModelElement())).getPartWithPort() != null) {
            return this.getHintedChildEditPart((EObject)ConnectorEndConvention.getTargetEnd((Connector)((Connector)descriptor.getModelElement())).getPartWithPort(), descriptor.getDestination(), domain2NotationMap, 3016);
        }
        return this.getTargetEditPartGen(descriptor, domain2NotationMap);
    }

    protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHinted(domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    protected final EditPart getHintedChildEditPart(EObject parent, EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHintedChild(parent, domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private static class Domain2Notation {
        private final HashMap myMap = new HashMap();

        private Domain2Notation() {
        }

        public boolean containsDomainElement(EObject domainElement) {
            return this.myMap.containsKey(domainElement);
        }

        public boolean containsKey(EObject domainElement) {
            return this.containsDomainElement(domainElement);
        }

        public void put(EObject domainElement, View view) {
            Object viewOrList = this.myMap.get(domainElement);
            if (viewOrList instanceof View) {
                this.myMap.remove(domainElement);
                LinkedList<View> list = new LinkedList<View>();
                list.add((View)viewOrList);
                this.myMap.put(domainElement, list);
                list.add(view);
            } else if (viewOrList instanceof List) {
                ((List)viewOrList).add(view);
            } else {
                this.myMap.put(domainElement, view);
            }
        }

        public View get(EObject domainEObject) {
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (nextView.getEAnnotation("Shortcut") != null) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }

        public View getHinted(EObject domainEObject, String hint) {
            if (hint == null) {
                return this.get(domainEObject);
            }
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            for (Object next : (List)viewOrList) {
                View nextView = (View)next;
                if (!hint.equals(nextView.getType())) continue;
                return nextView;
            }
            return (View)((List)viewOrList).get(0);
        }

        public View getHintedChild(EObject parent, EObject domainEObject, String hint) {
            if (domainEObject == null) {
                return null;
            }
            if (hint == null) {
                return this.get(domainEObject);
            }
            View parentView = this.get(parent);
            if (parentView == null) {
                return null;
            }
            EList children = parentView.getChildren();
            for (Object child : children) {
                View nextView = (View)child;
                if (!domainEObject.equals(nextView.getElement()) || !hint.equals(nextView.getType())) continue;
                return nextView;
            }
            return null;
        }
    }
}

