/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBaseSwitch.java,v 1.1 2007/03/18 08:10:09 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfbase.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage
 * @generated
 */
public class RDFBaseSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static RDFBasePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFBaseSwitch() {
		if (modelPackage == null) {
			modelPackage = RDFBasePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case RDFBasePackage.BLANK_NODE: {
				BlankNode blankNode = (BlankNode)theEObject;
				Object result = caseBlankNode(blankNode);
				if (result == null) result = caseRDFSResource(blankNode);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDFS_RESOURCE: {
				RDFSResource rdfsResource = (RDFSResource)theEObject;
				Object result = caseRDFSResource(rdfsResource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDF_PROPERTY: {
				RDFProperty rdfProperty = (RDFProperty)theEObject;
				Object result = caseRDFProperty(rdfProperty);
				if (result == null) result = caseRDFSResource(rdfProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.PLAIN_LITERAL: {
				PlainLiteral plainLiteral = (PlainLiteral)theEObject;
				Object result = casePlainLiteral(plainLiteral);
				if (result == null) result = caseRDFSLiteral(plainLiteral);
				if (result == null) result = caseRDFSResource(plainLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDFS_LITERAL: {
				RDFSLiteral rdfsLiteral = (RDFSLiteral)theEObject;
				Object result = caseRDFSLiteral(rdfsLiteral);
				if (result == null) result = caseRDFSResource(rdfsLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.URI_REFERENCE: {
				URIReference uriReference = (URIReference)theEObject;
				Object result = caseURIReference(uriReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDF_STATEMENT: {
				RDFStatement rdfStatement = (RDFStatement)theEObject;
				Object result = caseRDFStatement(rdfStatement);
				if (result == null) result = caseRDFSResource(rdfStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.UNIFORM_RESOURCE_IDENTIFIER: {
				UniformResourceIdentifier uniformResourceIdentifier = (UniformResourceIdentifier)theEObject;
				Object result = caseUniformResourceIdentifier(uniformResourceIdentifier);
				if (result == null) result = caseURIReference(uniformResourceIdentifier);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDF_GRAPH: {
				RDFGraph graph = (RDFGraph)theEObject;
				Object result = caseGraph(graph);
				if (result == null) result = caseRDFSResource(graph);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.URI_REFERENCE_NODE: {
				URIReferenceNode uriReferenceNode = (URIReferenceNode)theEObject;
				Object result = caseURIReferenceNode(uriReferenceNode);
				if (result == null) result = caseRDFSResource(uriReferenceNode);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.TYPED_LITERAL: {
				TypedLiteral typedLiteral = (TypedLiteral)theEObject;
				Object result = caseTypedLiteral(typedLiteral);
				if (result == null) result = caseRDFSLiteral(typedLiteral);
				if (result == null) result = caseRDFSResource(typedLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFBasePackage.RDFXML_LITERAL: {
				RDFXMLLiteral rdfxmlLiteral = (RDFXMLLiteral)theEObject;
				Object result = caseRDFXMLLiteral(rdfxmlLiteral);
				if (result == null) result = caseTypedLiteral(rdfxmlLiteral);
				if (result == null) result = caseRDFSLiteral(rdfxmlLiteral);
				if (result == null) result = caseRDFSResource(rdfxmlLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Blank Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Blank Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBlankNode(BlankNode object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSResource(RDFSResource object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFProperty(RDFProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Plain Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Plain Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePlainLiteral(PlainLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSLiteral(RDFSLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>URI Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>URI Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseURIReference(URIReference object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Statement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFStatement(RDFStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Uniform Resource Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Uniform Resource Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseUniformResourceIdentifier(UniformResourceIdentifier object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFGraph</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFGraph</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseGraph(RDFGraph object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>URI Reference Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>URI Reference Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseURIReferenceNode(URIReferenceNode object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Typed Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Typed Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTypedLiteral(TypedLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFXML Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFXML Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFXMLLiteral(RDFXMLLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //RDFBaseSwitch
