/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFParserResultHandler.java,v 1.1 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.impl;

import org.eclipse.eodm.rdf.resource.parser.NamespaceHandler;
import org.eclipse.eodm.rdf.resource.parser.StatementHandler;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;

/**
 * RDFParserResultHandler an interface implementation to get RDF statements
 */
public class RDFParserResultHandler implements StatementHandler,
        NamespaceHandler {

    RDFTripleAnalyzer analyser = null;

    public RDFParserResultHandler(RDFTripleAnalyzer analyser) {
        if (analyser == null)
            throw new IllegalArgumentException(
                    "The RDF triple analyser can not be null.");
        this.analyser = analyser;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.rdf.resource.parser.StatementHandler#exportStatement(org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement,
     *      org.eclipse.eodm.rdf.resource.parser.element.URIReference,
     *      org.eclipse.eodm.rdf.resource.parser.element.RDFValue)
     */
    public void exportStatement(RDFResourceElement subject,
            URIReference predicate, RDFValue object) {
        analyser.analyseTriple(subject, predicate, object);
        // if (object instanceof RDFResourceElement)
        // System.out.println(subject.getFullURI()+" " + predicate.getFullURI()+
        // " "+ ((RDFResourceElement)object).getFullURI()) ;
        // else if (object instanceof RDFBlankNode)
        // System.out.println(subject.getFullURI()+" " + predicate.getFullURI()+
        // " "+ ((RDFBlankNode)object).getFullURI()) ;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.rdf.resource.parser.StatementHandler#exportReification(org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement,
     *      org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement,
     *      org.eclipse.eodm.rdf.resource.parser.element.URIReference,
     *      org.eclipse.eodm.rdf.resource.parser.element.RDFValue)
     */
    public void exportReification(RDFResourceElement reifyNode,
            RDFResourceElement subject, URIReference predicate, RDFValue object) {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.rdf.resource.parser.StatementHandler#setSeparateExport(boolean)
     */
    public void setSeparateExport(boolean exportSeparate) {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.rdf.resource.parser.StatementHandler#isSeparateExport()
     */
    public boolean isSeparateExport() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.rdf.resource.parser.NamespaceHandler#exportNamespace(java.lang.String,
     *      java.lang.String)
     */
    public void exportNamespace(String abbr, String fullURI) {
        analyser.handleNamespace(abbr, fullURI);
    }
}