/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.ComplementClass;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.HasValueRestriction;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.OWLOntologyProperty;
import org.eclipse.eodm.owl.owlbase.OWLRestriction;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.RDFSContainer;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.util.Triple;

public class OWLXMLSaverImpl {
    public static final String OWL_PREFIX = "owl:";
    public static final String RDF_PREFIX = "rdf:";
    public static final String RDFS_PREFIX = "rdfs:";
    private Writer writer = null;
    private OWLOntology ontology = null;
    private Document document = null;
    protected Hashtable NamespaceHashTable = new Hashtable();
    private static final int PLUS = 1;
    private static final int STAY = 0;
    private static final int REDUCTION = -1;
    private int indentLevel = 1;
    private List unusedElements = new Vector();
    private Map usedElements = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;

    public OWLXMLSaverImpl(Writer writer, Document doc) {
        this.writer = writer;
        this.document = doc;
        Iterator iter = this.document.getNamespaceDefinition().iterator();
        while (iter.hasNext()) {
            NamespaceDefinition namespace = (NamespaceDefinition)iter.next();
            this.NamespaceHashTable.put(namespace.getNamespace().getNamespaceURIRef().getURIString(), namespace.getNamespacePrefix());
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/2000/01/rdf-schema#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/2001/XMLSchema#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/2002/07/owl#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/2002/07/owl#", "owl");
        }
    }

    private void writeIndents(int oper) throws IOException {
        if (oper == -1) {
            --this.indentLevel;
        }
        int i = this.indentLevel;
        while (i > 0) {
            this.writer.write("\t");
            --i;
        }
        if (oper == 1) {
            ++this.indentLevel;
        }
    }

    public void save() throws IOException, UnsupportedViewTypeException {
        RDFSResource resource;
        Object object;
        Iterator graphIter = this.document.getComplementalGraph().getAllResources();
        ArrayList ontolist = null;
        ontolist = this.document.getComplementalGraph().getTypeResources("http://www.w3.org/2002/07/owl#Ontology");
        if (ontolist != null && ontolist.size() > 0) {
            this.ontology = (OWLOntology)ontolist.get(0);
            this.writeOntoHeader(this.ontology, false, false);
        }
        ArrayList allResources = new ArrayList();
        ArrayList<RDFSResource> ResourceWithSameURI = new ArrayList<RDFSResource>();
        String preURI = "";
        boolean bURIReferenceNode = false;
        Iterator iterator = graphIter;
        while (iterator.hasNext()) {
            object = iterator.next();
            resource = (RDFSResource)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFSLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.canAsType((Class)clazz)) continue;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.eodm.rdf.rdfbase.BlankNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.canAsType((Class)clazz2)) continue;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntology");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.canAsType((Class)clazz3)) continue;
            if (!resource.getURI().equals(preURI)) {
                if (ResourceWithSameURI.size() > 0) {
                    allResources.addAll(ResourceWithSameURI);
                    ResourceWithSameURI.clear();
                }
                preURI = resource.getURI();
                ResourceWithSameURI.add(resource);
                bURIReferenceNode = false;
                continue;
            }
            if (ResourceWithSameURI.size() > 0 && resource.eClass().getName().equals("URIReferenceNode")) continue;
            if (!resource.eClass().getName().equals("URIReferenceNode")) {
                if (!bURIReferenceNode) {
                    Iterator iter = ResourceWithSameURI.iterator();
                    while (iter.hasNext()) {
                        RDFSResource res = (RDFSResource)iter.next();
                        if (!res.eClass().getName().equals("URIReferenceNode")) continue;
                        ResourceWithSameURI.remove(res);
                        iter = ResourceWithSameURI.iterator();
                    }
                }
                bURIReferenceNode = true;
            }
            ResourceWithSameURI.add(resource);
        }
        if (ResourceWithSameURI.size() > 0) {
            allResources.addAll(ResourceWithSameURI);
            ResourceWithSameURI.clear();
        }
        iterator = allResources.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            resource = (RDFSResource)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFSLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.canAsType((Class)clazz)) continue;
            if (!this.isAnonymousElement(resource)) {
                System.out.println(String.valueOf(resource.getURI()) + " type: " + resource.eClass().getName());
                this.saveResource(resource);
                continue;
            }
            this.unusedElements.add(resource);
        }
        int i = 0;
        int n = this.unusedElements.size();
        while (i < n) {
            resource = (RDFSResource)this.unusedElements.get(i);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.eodm.rdf.rdfbase.BlankNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!resource.canAsType((Class)clazz)) {
                if (!this.usedElements.containsKey(resource.getURI())) {
                    this.saveResource(resource);
                }
            } else if (!this.usedElements.containsKey(resource.getNodeID())) {
                this.saveResource(resource);
            }
            ++i;
        }
    }

    private void saveResource(RDFSResource resource) throws IOException, UnsupportedViewTypeException {
        this.indentLevel = 1;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resource.canAsType((Class)clazz)) {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.writeClass((OWLClass)resource.asType((Class)clazz2), false, false);
        } else {
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (resource.canAsType((Class)clazz3)) {
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeObjProperty((OWLObjectProperty)resource.asType((Class)clazz4), false, false);
            } else {
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (resource.canAsType((Class)clazz5)) {
                    Class<?> clazz6 = class$5;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$5 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.writeDatatypeProperty((OWLDatatypeProperty)resource.asType((Class)clazz6), false, false);
                } else {
                    Class<?> clazz7 = class$6;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$6 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (resource.canAsType((Class)clazz7)) {
                        Class<?> clazz8 = class$6;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$6 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeAnnoProperty((OWLAnnotationProperty)resource.asType((Class)clazz8), false, false);
                    } else {
                        Class<?> clazz9 = class$7;
                        if (clazz9 == null) {
                            try {
                                clazz9 = class$7 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntologyProperty");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (resource.canAsType((Class)clazz9)) {
                            Class<?> clazz10 = class$7;
                            if (clazz10 == null) {
                                try {
                                    clazz10 = class$7 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntologyProperty");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.writeOntoProperty((OWLOntologyProperty)resource.asType((Class)clazz10), false, false);
                        } else {
                            Class<?> clazz11 = class$8;
                            if (clazz11 == null) {
                                try {
                                    clazz11 = class$8 = Class.forName("org.eclipse.eodm.owl.owlbase.Individual");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (resource.canAsType((Class)clazz11)) {
                                Class<?> clazz12 = class$8;
                                if (clazz12 == null) {
                                    try {
                                        clazz12 = class$8 = Class.forName("org.eclipse.eodm.owl.owlbase.Individual");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.writeIndividual((Individual)resource.asType((Class)clazz12), false, false);
                            } else {
                                Class<?> clazz13 = class$9;
                                if (clazz13 == null) {
                                    try {
                                        clazz13 = class$9 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFSContainer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (resource.canAsType((Class)clazz13)) {
                                    Class<?> clazz14 = class$9;
                                    if (clazz14 == null) {
                                        try {
                                            clazz14 = class$9 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFSContainer");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.writeContainer((RDFSContainer)resource.asType((Class)clazz14), false, false);
                                } else {
                                    Class<?> clazz15 = class$10;
                                    if (clazz15 == null) {
                                        try {
                                            clazz15 = class$10 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFStatement");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (resource.canAsType((Class)clazz15)) {
                                        Class<?> clazz16 = class$10;
                                        if (clazz16 == null) {
                                            try {
                                                clazz16 = class$10 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFStatement");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        this.writeStatement((RDFStatement)resource.asType((Class)clazz16), false, false);
                                    } else {
                                        Class<?> clazz17 = class$11;
                                        if (clazz17 == null) {
                                            try {
                                                clazz17 = class$11 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDataRange");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (resource.canAsType((Class)clazz17)) {
                                            Class<?> clazz18 = class$11;
                                            if (clazz18 == null) {
                                                try {
                                                    clazz18 = class$11 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDataRange");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            this.writeDataRange((OWLDataRange)resource.asType((Class)clazz18), false, false);
                                        } else {
                                            Class<?> clazz19 = class$12;
                                            if (clazz19 == null) {
                                                try {
                                                    clazz19 = class$12 = Class.forName("org.eclipse.eodm.rdf.rdfbase.URIReferenceNode");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (resource.canAsType((Class)clazz19)) {
                                                Class<?> clazz20 = class$12;
                                                if (clazz20 == null) {
                                                    try {
                                                        clazz20 = class$12 = Class.forName("org.eclipse.eodm.rdf.rdfbase.URIReferenceNode");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                this.writeURIReferenceNode((URIReferenceNode)resource.asType((Class)clazz20), false, false);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void writeOntoProperty(OWLOntologyProperty ontoProperty, boolean isReferenced, boolean referencedAsNode) throws IOException {
        this.startElement((RDFSResource)ontoProperty, "owl:OntologyProperty", isReferenced, referencedAsNode);
        this.endElement("owl:OntologyProperty");
    }

    private void writeAnnoProperty(OWLAnnotationProperty annoProperty, boolean isReferenced, boolean referencedAsNode) throws IOException {
        this.startElement((RDFSResource)annoProperty, "owl:AnnotationProperty", isReferenced, referencedAsNode);
        this.endElement("owl:AnnotationProperty");
    }

    private void writeOntoHeader(OWLOntology onto, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)onto, "owl:Ontology", isReferenced, referencedAsNode);
        if (!isReferenced) {
            this.writeOntoAttrs(onto);
        }
        this.endElement("owl:Ontology");
    }

    private void writeOntoAttrs(OWLOntology onto) throws IOException, UnsupportedViewTypeException {
        Iterator iter;
        if (onto.getOWLpriorVersion() != null) {
            iter = onto.getOWLpriorVersion().iterator();
            while (iter.hasNext()) {
                this.writeIndents(1);
                this.writer.write("<owl:priorVersion>\n");
                this.writeOntoHeader((OWLOntology)iter.next(), true, true);
                this.writeIndents(-1);
                this.writer.write("</owl:priorVersion>\n");
            }
        }
        if (onto.getOWLbackwardCompatibleWith() != null) {
            iter = onto.getOWLbackwardCompatibleWith().iterator();
            while (iter.hasNext()) {
                this.writeIndents(1);
                this.writer.write("<owl:backwardCompatibleWith>\n");
                this.writeOntoHeader((OWLOntology)iter.next(), true, true);
                this.writeIndents(-1);
                this.writer.write("</owl:backwardCompatibleWith>\n");
            }
        }
        if (onto.getOWLincompatibleWith() != null) {
            iter = onto.getOWLincompatibleWith().iterator();
            while (iter.hasNext()) {
                this.writeIndents(1);
                this.writer.write("<owl:incompatibleWith>\n");
                this.writeOntoHeader((OWLOntology)iter.next(), true, true);
                this.writeIndents(-1);
                this.writer.write("</owl:incompatibleWith>\n");
            }
        }
        if (onto.getOWLversionInfo() != null) {
            iter = onto.getOWLversionInfo().iterator();
            while (iter.hasNext()) {
                this.writeAttribute("owl:versionInfo", (RDFSResource)iter.next());
            }
        }
        this.writeAttributes("owl:imports", onto.getOWLimports());
        this.writeRDFSResourceAttrs((RDFSResource)this.ontology);
    }

    private void writeClass(OWLClass cls, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.eodm.rdf.rdfbase.BlankNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (cls.canAsType((Class)clazz)) {
            this.usedElements.put(cls.getNodeID(), cls);
        } else {
            this.usedElements.put(cls.getURI(), cls);
        }
        if (isReferenced && !this.isAnonymousElement((RDFSResource)cls)) {
            this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
            this.endElement("owl:Class");
            return;
        }
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLRestriction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (cls.canAsType((Class)clazz2)) {
            Class<?> clazz3 = class$13;
            if (clazz3 == null) {
                try {
                    clazz3 = class$13 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLRestriction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.writeRestriction((OWLRestriction)cls.asType((Class)clazz3), isReferenced, referencedAsNode);
            return;
        }
        Class<?> clazz4 = class$14;
        if (clazz4 == null) {
            try {
                clazz4 = class$14 = Class.forName("org.eclipse.eodm.owl.owlbase.EnumeratedClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (cls.canAsType((Class)clazz4)) {
            Class<?> clazz5 = class$14;
            if (clazz5 == null) {
                try {
                    clazz5 = class$14 = Class.forName("org.eclipse.eodm.owl.owlbase.EnumeratedClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.writeEnumeratedCls((EnumeratedClass)cls.asType((Class)clazz5), isReferenced, referencedAsNode);
        } else {
            Class<?> clazz6 = class$15;
            if (clazz6 == null) {
                try {
                    clazz6 = class$15 = Class.forName("org.eclipse.eodm.owl.owlbase.ComplementClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (cls.canAsType((Class)clazz6)) {
                Class<?> clazz7 = class$15;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$15 = Class.forName("org.eclipse.eodm.owl.owlbase.ComplementClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeComplementCls((ComplementClass)cls.asType((Class)clazz7), isReferenced, referencedAsNode);
            } else {
                Class<?> clazz8 = class$16;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$16 = Class.forName("org.eclipse.eodm.owl.owlbase.UnionClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cls.canAsType((Class)clazz8)) {
                    Class<?> clazz9 = class$16;
                    if (clazz9 == null) {
                        try {
                            clazz9 = class$16 = Class.forName("org.eclipse.eodm.owl.owlbase.UnionClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.writeUnionCls((UnionClass)cls.asType((Class)clazz9), isReferenced, referencedAsNode);
                } else {
                    Class<?> clazz10 = class$17;
                    if (clazz10 == null) {
                        try {
                            clazz10 = class$17 = Class.forName("org.eclipse.eodm.owl.owlbase.IntersectionClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (cls.canAsType((Class)clazz10)) {
                        Class<?> clazz11 = class$17;
                        if (clazz11 == null) {
                            try {
                                clazz11 = class$17 = Class.forName("org.eclipse.eodm.owl.owlbase.IntersectionClass");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeIntersectionCls((IntersectionClass)cls.asType((Class)clazz11), isReferenced, referencedAsNode);
                    } else {
                        this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
                        if (!isReferenced || this.isAnonymousElement((RDFSResource)cls)) {
                            this.writeClsAttrs(cls);
                        }
                        this.endElement("owl:Class");
                        if (cls.isIsDeprecated()) {
                            this.startElement((RDFSResource)cls, "owl:DeprecatedClass", isReferenced, referencedAsNode);
                            this.endElement("owl:DeprecatedClass");
                        }
                    }
                }
            }
        }
    }

    private void writeClsAttrs(OWLClass cls) throws IOException, UnsupportedViewTypeException {
        this.writeAttributes("owl:equivalentClass", cls.getEquivalentClass());
        this.writeAttributes("owl:disjointWith", cls.getOWLdisjointWith());
        this.writeAttributes("rdfs:subClassOf", cls.getRDFSsubClassOf());
        this.writeRDFSResourceAttrs((RDFSResource)cls);
    }

    private void writeRestriction(OWLRestriction restriction, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        if (!isReferenced && !this.isAnonymousElement((RDFSResource)restriction)) {
            this.startElement((RDFSResource)restriction, "owl:Class", isReferenced, referencedAsNode);
            this.writeIndents(1);
            this.writer.write("<owl:equivalentClass>\n");
            this.writeIndents(1);
            this.writer.write("<owl:Restriction>\n");
        } else {
            this.writeIndents(1);
            if (this.isAnonymousElement((RDFSResource)restriction)) {
                this.writer.write("<owl:Restriction rdf:nodeID=\"" + restriction.getNodeID() + "\">\n");
            } else {
                URIReference uri = (URIReference)restriction.getUriRef().get(0);
                String abbreviation = null;
                abbreviation = (String)this.NamespaceHashTable.get(uri.getURIString());
                if (abbreviation != null) {
                    if (uri.getURIString().indexOf("%") == -1) {
                        this.writer.write("<owl:Restriction rdf:about=\"&" + abbreviation + ";" + uri.getFragmentIdentifier().getName() + "\">");
                    } else {
                        this.writer.write("<owl:Restriction rdf:about=\"" + uri.getURIString() + "\">");
                    }
                } else {
                    this.writer.write("<owl:Restriction rdf:about=\"" + uri.getURIString() + "\">");
                }
            }
        }
        this.writeAttribute("owl:onProperty", (RDFSResource)restriction.getOWLonProperty());
        Class<?> clazz = class$18;
        if (clazz == null) {
            try {
                clazz = class$18 = Class.forName("org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (restriction.canAsType((Class)clazz)) {
            Class<?> clazz2 = class$18;
            if (clazz2 == null) {
                try {
                    clazz2 = class$18 = Class.forName("org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (((AllValuesFromRestriction)restriction.asType((Class)clazz2)).getAllValuesFromClass() != null) {
                Class<?> clazz3 = class$18;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$18 = Class.forName("org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeAttribute("owl:allValuesFrom", (RDFSResource)((AllValuesFromRestriction)restriction.asType((Class)clazz3)).getAllValuesFromClass());
            } else {
                Class<?> clazz4 = class$18;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$18 = Class.forName("org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeAttribute("owl:allValuesFrom", (RDFSResource)((AllValuesFromRestriction)restriction.asType((Class)clazz4)).getAllValuesFromDataRange());
            }
        } else {
            Class<?> clazz5 = class$19;
            if (clazz5 == null) {
                try {
                    clazz5 = class$19 = Class.forName("org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (restriction.canAsType((Class)clazz5)) {
                Class<?> clazz6 = class$19;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$19 = Class.forName("org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (((SomeValuesFromRestriction)restriction.asType((Class)clazz6)).getSomeValuesFromClass() != null) {
                    Class<?> clazz7 = class$19;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$19 = Class.forName("org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.writeAttribute("owl:someValuesFrom", (RDFSResource)((SomeValuesFromRestriction)restriction.asType((Class)clazz7)).getSomeValuesFromClass());
                } else {
                    Class<?> clazz8 = class$19;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$19 = Class.forName("org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.writeAttribute("owl:someValuesFrom", (RDFSResource)((SomeValuesFromRestriction)restriction.asType((Class)clazz8)).getSomeValuesFromClass());
                }
            } else {
                Class<?> clazz9 = class$20;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$20 = Class.forName("org.eclipse.eodm.owl.owlbase.HasValueRestriction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (restriction.canAsType((Class)clazz9)) {
                    Class<?> clazz10 = class$20;
                    if (clazz10 == null) {
                        try {
                            clazz10 = class$20 = Class.forName("org.eclipse.eodm.owl.owlbase.HasValueRestriction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (((HasValueRestriction)restriction.asType((Class)clazz10)).getHasIndividualValue() != null) {
                        Class<?> clazz11 = class$20;
                        if (clazz11 == null) {
                            try {
                                clazz11 = class$20 = Class.forName("org.eclipse.eodm.owl.owlbase.HasValueRestriction");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeAttribute("owl:hasValue", (RDFSResource)((HasValueRestriction)restriction.asType((Class)clazz11)).getHasIndividualValue());
                    } else {
                        Class<?> clazz12 = class$20;
                        if (clazz12 == null) {
                            try {
                                clazz12 = class$20 = Class.forName("org.eclipse.eodm.owl.owlbase.HasValueRestriction");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeAttribute("owl:hasValue", (RDFSResource)((HasValueRestriction)restriction.asType((Class)clazz12)).getHasLiteralValue());
                    }
                } else {
                    Class<?> clazz13 = class$21;
                    if (clazz13 == null) {
                        try {
                            clazz13 = class$21 = Class.forName("org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (restriction.canAsType((Class)clazz13)) {
                        Class<?> clazz14 = class$21;
                        if (clazz14 == null) {
                            try {
                                clazz14 = class$21 = Class.forName("org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeAttribute("owl:maxCardinality", (RDFSResource)((MaxCardinalityRestriction)restriction.asType((Class)clazz14)).getOWLmaxCardinality());
                    } else {
                        Class<?> clazz15 = class$22;
                        if (clazz15 == null) {
                            try {
                                clazz15 = class$22 = Class.forName("org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (restriction.canAsType((Class)clazz15)) {
                            Class<?> clazz16 = class$22;
                            if (clazz16 == null) {
                                try {
                                    clazz16 = class$22 = Class.forName("org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.writeAttribute("owl:minCardinality", (RDFSResource)((MinCardinalityRestriction)restriction.asType((Class)clazz16)).getOWLminCardinality());
                        } else {
                            Class<?> clazz17 = class$23;
                            if (clazz17 == null) {
                                try {
                                    clazz17 = class$23 = Class.forName("org.eclipse.eodm.owl.owlbase.CardinalityRestriction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (restriction.canAsType((Class)clazz17)) {
                                Class<?> clazz18 = class$23;
                                if (clazz18 == null) {
                                    try {
                                        clazz18 = class$23 = Class.forName("org.eclipse.eodm.owl.owlbase.CardinalityRestriction");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.writeAttribute("owl:cardinality", (RDFSResource)((CardinalityRestriction)restriction.asType((Class)clazz18)).getOWLcardinality());
                            }
                        }
                    }
                }
            }
        }
        this.writeClsAttrs((OWLClass)restriction);
        this.endElement("owl:Restriction");
        if (!isReferenced && !this.isAnonymousElement((RDFSResource)restriction)) {
            this.writeIndents(-1);
            this.writer.write("</owl:equivalentClass>\n");
            this.endElement("owl:Class");
        }
    }

    private void writeEnumeratedCls(EnumeratedClass cls, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
        EList list = cls.getOWLoneOf();
        this.writeIndents(1);
        this.writer.write("<owl:oneOf rdf:parseType=\"Collection\">\n");
        int i = 0;
        while (i < list.size()) {
            this.writeIndividual((Individual)list.get(i), true, true);
            ++i;
        }
        this.writeIndents(-1);
        this.writer.write("</owl:oneOf>\n");
        this.writeClsAttrs((OWLClass)cls);
        this.endElement("owl:Class");
    }

    private void writeIntersectionCls(IntersectionClass cls, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
        this.writeIndents(1);
        EList list = cls.getOWLintersectionOf();
        this.writer.write("<owl:intersectionOf rdf:parseType=\"Collection\">\n");
        int i = 0;
        while (i < list.size()) {
            this.writeClass((OWLClass)list.get(i), true, true);
            ++i;
        }
        this.writeIndents(-1);
        this.writer.write("</owl:intersectionOf>\n");
        this.writeClsAttrs((OWLClass)cls);
        this.endElement("owl:Class");
    }

    private void writeUnionCls(UnionClass cls, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
        this.writeIndents(1);
        EList list = cls.getOWLunionOf();
        this.writer.write("<owl:unionOf rdf:parseType=\"Collection\">\n");
        int i = 0;
        while (i < list.size()) {
            this.writeClass((OWLClass)list.get(i), true, true);
            ++i;
        }
        this.writeIndents(-1);
        this.writer.write("</owl:unionOf>\n");
        this.writeClsAttrs((OWLClass)cls);
        this.endElement("owl:Class");
    }

    private void writeComplementCls(ComplementClass cls, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)cls, "owl:Class", isReferenced, referencedAsNode);
        this.writeAttribute("owl:complementOf", (RDFSResource)cls.getOWLcomplementOf());
        this.writeClsAttrs((OWLClass)cls);
        this.endElement("owl:Class");
    }

    private void writeObjProperty(OWLObjectProperty property, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)property, "owl:ObjectProperty", isReferenced, referencedAsNode);
        this.writeAttributes("owl:inverseOf", property.getOWLinverseOf());
        this.writeAttributes("owl:equivalentProperty", property.getOWLequivalentProperty());
        if (property.isIsTransitive()) {
            this.writeIndents(0);
            this.writer.write("<rdf:type rdf:resource= \"http://www.w3.org/2002/07/owl#TransitiveProperty\"/>\n");
        }
        if (property.isIsFunctional()) {
            this.writeIndents(0);
            this.writer.write("<rdf:type rdf:resource= \"http://www.w3.org/2002/07/owl#FunctionalProperty\"/>\n");
        }
        if (property.isIsSymmetric()) {
            this.writeIndents(0);
            this.writer.write("<rdf:type rdf:resource= \"http://www.w3.org/2002/07/owl#SymmetricProperty\"/>\n");
        }
        if (property.isIsInverseFunctional()) {
            this.writeIndents(0);
            this.writer.write("<rdf:type rdf:resource= \"http://www.w3.org/2002/07/owl#InverseFunctionalProperty\"/>\n");
        }
        this.writeRDFPropertyAttrs((RDFProperty)property);
        this.endElement("owl:ObjectProperty");
        if (property.isIsPropertyDeprecated()) {
            this.startElement((RDFSResource)property, "owl:DeprecatedProperty", isReferenced, referencedAsNode);
            this.endElement("owl:DeprecatedProperty");
        }
    }

    private void writeDatatypeProperty(OWLDatatypeProperty property, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)property, "owl:DatatypeProperty", isReferenced, referencedAsNode);
        if (property.getOWLequivalentProperty() != null) {
            this.writeAttributes("owl:equivalentProperty", property.getOWLequivalentProperty());
        }
        if (property.isIsFunctional()) {
            this.writeIndents(0);
            this.writer.write("<rdf:type rdf:resource= \"http://www.w3.org/2002/07/owl#FunctionalProperty\"/>\n");
        }
        this.writeRDFPropertyAttrs((RDFProperty)property);
        this.endElement("owl:DatatypeProperty");
        if (property.isIsPropertyDeprecated()) {
            this.startElement((RDFSResource)property, "owl:DeprecatedProperty", isReferenced, referencedAsNode);
            this.endElement("owl:DeprecatedProperty");
        }
    }

    private void writeRDFPropertyAttrs(RDFProperty property) throws IOException, UnsupportedViewTypeException {
        this.writeAttributes("rdfs:subPropertyOf", property.getRDFSsubPropertyOf());
        this.writeAttributes("rdfs:domain", property.getRDFSdomain());
        this.writeAttributes("rdfs:range", property.getRDFSrange());
        this.writeRDFSResourceAttrs((RDFSResource)property);
    }

    private void writeRDFSResourceAttrs(RDFSResource resource) throws IOException, UnsupportedViewTypeException {
        this.writeAttributes("rdfs:isDefinedBy", resource.getRDFSisDefinedBy());
        this.writeAttributes("rdfs:seeAlso", resource.getRDFSseeAlso());
        this.writeAttributes("rdfs:comment", resource.getRDFScomment());
        this.writeAttributes("rdf:li", resource.getRDFSmember());
        this.writeAttributes("rdfs:label", resource.getRDFSlabel());
    }

    private void writeIndividual(Individual inv, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        String type = null;
        String uri = null;
        int i = 0;
        while (i < inv.getRDFtype().size()) {
            RDFSClass cls = (RDFSClass)inv.getRDFtype().get(i);
            if (!cls.getURI().equals("http://www.w3.org/2002/07/owl#Thing")) {
                String nsURI = (String)this.NamespaceHashTable.get(((URIReference)cls.getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString());
                type = String.valueOf(OWLXMLSaverImpl.replaceKeywords(nsURI)) + ":" + ((URIReference)cls.getUriRef().get(0)).getFragmentIdentifier().getName();
                uri = cls.getURI();
                break;
            }
            ++i;
        }
        if (type == null) {
            type = "owl:Thing";
            uri = "http://www.w3.org/2002/07/owl#Thing";
        }
        if (inv.getURI().indexOf("Medium") != -1) {
            System.out.print("dads");
        }
        this.startElement((RDFSResource)inv, type, isReferenced, referencedAsNode);
        if (!isReferenced) {
            this.writeAttributes("owl:differentFrom", inv.getOWLdifferentFrom());
            this.writeAttributes("owl:sameAs", inv.getOWLsameAs());
            Iterator iter = inv.getCustomTriples().iterator();
            while (iter.hasNext()) {
                Triple triple = (Triple)iter.next();
                RDFSResource[] prop = this.document.getComplementalGraph().getRDFSResource(triple.getPredicate()).getAllTypeViews();
                int i2 = 0;
                while (i2 < prop.length) {
                    if (prop[i2] instanceof RDFProperty) {
                        RDFSResource[] res;
                        EList obj;
                        if (triple.isObjectLiteral()) {
                            obj = (EList)new ArrayList();
                            obj.add((Object)triple.getObjectLiteral());
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        } else if (triple.isObjectBlankNode()) {
                            obj = (EList)new ArrayList();
                            res = this.document.getComplementalGraph().getRDFSResource(triple.getObjectNodeID()).getAllTypeViews();
                            obj.add((Object)res[0]);
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        } else {
                            obj = (EList)new ArrayList();
                            res = this.document.getComplementalGraph().getRDFSResource(triple.getObjectURI()).getAllTypeViews();
                            obj.add((Object)res[0]);
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        }
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < inv.getRDFtype().size()) {
                RDFSClass cls = (RDFSClass)inv.getRDFtype().get(i3);
                if (!cls.getURI().equals("http://www.w3.org/2002/07/owl#Thing") && !cls.getURI().equals(uri)) {
                    this.writeAttribute("rdf:type", (RDFSResource)cls);
                }
                ++i3;
            }
            this.writeRDFSResourceAttrs((RDFSResource)inv);
        }
        this.endElement(type);
    }

    private void writeURIReferenceNode(URIReferenceNode inv, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        String type = null;
        String uri = null;
        int i = 0;
        while (i < inv.getRDFtype().size()) {
            RDFSClass cls = (RDFSClass)inv.getRDFtype().get(i);
            if (!cls.getURI().equals("http://www.w3.org/2002/07/owl#Thing")) {
                String nsURI = (String)this.NamespaceHashTable.get(((URIReference)cls.getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString());
                type = String.valueOf(OWLXMLSaverImpl.replaceKeywords(nsURI)) + ":" + ((URIReference)cls.getUriRef().get(0)).getFragmentIdentifier().getName();
                uri = cls.getURI();
                break;
            }
            ++i;
        }
        if (type == null) {
            type = "rdf:Description";
            uri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Description";
        }
        this.startElement((RDFSResource)inv, type, isReferenced, referencedAsNode);
        if (!isReferenced) {
            Iterator iter = inv.getCustomTriples().iterator();
            while (iter.hasNext()) {
                Triple triple = (Triple)iter.next();
                RDFSResource[] prop = this.document.getComplementalGraph().getRDFSResource(triple.getPredicate()).getAllTypeViews();
                int i2 = 0;
                while (i2 < prop.length) {
                    if (prop[i2] instanceof RDFProperty) {
                        RDFSResource[] res;
                        EList obj;
                        if (triple.isObjectLiteral()) {
                            obj = (EList)new ArrayList();
                            obj.add((Object)triple.getObjectLiteral());
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        } else if (triple.isObjectBlankNode()) {
                            obj = (EList)new ArrayList();
                            res = this.document.getComplementalGraph().getRDFSResource(triple.getObjectNodeID()).getAllTypeViews();
                            obj.add((Object)res[0]);
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        } else {
                            obj = (EList)new ArrayList();
                            res = this.document.getComplementalGraph().getRDFSResource(triple.getObjectURI()).getAllTypeViews();
                            obj.add((Object)res[0]);
                            this.writeAttributes(this.NamespaceHashTable.get(((URIReference)prop[i2].getUriRef().get(0)).getNamespace().getNamespaceURIRef().getURIString()) + ":" + ((URIReference)prop[i2].getUriRef().get(0)).getFragmentIdentifier().getName(), obj);
                        }
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < inv.getRDFtype().size()) {
                RDFSClass cls = (RDFSClass)inv.getRDFtype().get(i3);
                if (!cls.getURI().equals("http://www.w3.org/2002/07/owl#Thing") && !cls.getURI().equals(uri)) {
                    this.writeAttribute("rdf:type", (RDFSResource)cls);
                }
                ++i3;
            }
            this.writeRDFSResourceAttrs((RDFSResource)inv);
        }
        this.endElement(type);
    }

    private void writeDataRange(OWLDataRange range, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.usedElements.put(range.getNodeID(), range);
        this.startElement((RDFSResource)range, "owl:DataRange", isReferenced, referencedAsNode);
        this.writeIndents(1);
        this.writer.write("<owl:oneOf>\n");
        this.writeRDFList(range.getOWLDataRangeOneOf());
        this.writeIndents(-1);
        this.writer.write("</owl:oneOf>\n");
        this.writeAttributes("rdfs:subClassOf", range.getRDFSsubClassOf());
        this.writeRDFSResourceAttrs((RDFSResource)range);
        this.endElement("owl:DataRange");
    }

    private void writeRDFList(EList list) throws IOException, UnsupportedViewTypeException {
        int i = 0;
        while (i < list.size()) {
            this.writeIndents(1);
            this.writer.write("<rdf:List>\n");
            this.writeAttribute("rdf:first", (RDFSResource)((RDFSLiteral)list.get(i)));
            if (i == list.size() - 1) {
                this.writeIndents(0);
                this.writer.write("<rdf:rest rdf:resource=\"&rdf;nil\"/>\n");
            } else {
                this.writeIndents(1);
                this.writer.write("<rdf:rest>\n");
            }
            ++i;
        }
        i = list.size() - 1;
        while (i >= 0) {
            if (i < list.size() - 1) {
                this.writeIndents(-1);
                this.writer.write("</rdf:rest>\n");
            }
            this.writeIndents(-1);
            this.writer.write("</rdf:List>\n");
            --i;
        }
    }

    private void writeStatement(RDFStatement statement, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        this.startElement((RDFSResource)statement, "rdf:Statement", false, referencedAsNode);
        this.writeAttribute("rdf:subject", statement.getRDFsubject());
        this.writeAttribute("rdf:predicate", (RDFSResource)statement.getRDFpredicate());
        this.writeAttribute("rdf:object", statement.getRDFobject());
        this.writeRDFSResourceAttrs((RDFSResource)statement);
        this.endElement("rdf:Statement");
    }

    private void writeContainer(RDFSContainer container, boolean isReferenced, boolean referencedAsNode) throws IOException, UnsupportedViewTypeException {
        Class<?> clazz = class$24;
        if (clazz == null) {
            try {
                clazz = class$24 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFAlt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (container.canAsType((Class)clazz)) {
            this.startElement((RDFSResource)container, "rdf:Alt", isReferenced, referencedAsNode);
            this.writeRDFSResourceAttrs((RDFSResource)container);
            this.endElement("rdf:Alt");
            return;
        }
        Class<?> clazz2 = class$25;
        if (clazz2 == null) {
            try {
                clazz2 = class$25 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFBag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (container.canAsType((Class)clazz2)) {
            this.startElement((RDFSResource)container, "rdf:Bag", isReferenced, referencedAsNode);
            this.writeRDFSResourceAttrs((RDFSResource)container);
            this.endElement("rdf:Bag");
            return;
        }
        Class<?> clazz3 = class$26;
        if (clazz3 == null) {
            try {
                clazz3 = class$26 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFSeq");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (container.canAsType((Class)clazz3)) {
            this.startElement((RDFSResource)container, "rdf:Seq", isReferenced, referencedAsNode);
            this.writeRDFSResourceAttrs((RDFSResource)container);
            this.endElement("rdf:Seq");
            return;
        }
    }

    private void startElement(RDFSResource resource, String tag, boolean isReferenced, boolean referencedAsNode) throws IOException {
        this.writeIndents(1);
        this.writer.write("<" + tag + " " + this.getIDAttr(resource, isReferenced, referencedAsNode) + ">\n");
    }

    private void endElement(String tag) throws IOException {
        this.writeIndents(-1);
        this.writer.write("</" + tag + ">\n");
    }

    private boolean isAnonymousElement(RDFSResource resource) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.eodm.rdf.rdfbase.BlankNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return resource.canAsType((Class)clazz);
    }

    private String getIDAttr(RDFSResource resource, boolean isReferenced, boolean referencedAsNode) {
        if (this.isAnonymousElement(resource)) {
            if (resource.getNodeID() == null) {
                return "";
            }
            return "rdf:nodeID=\"" + resource.getNodeID() + "\"";
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLOntology");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resource.canAsType((Class)clazz)) {
            if (!isReferenced) {
                return "rdf:about=\"" + resource.getURI() + "\"";
            }
            if (referencedAsNode) {
                return "rdf:about=\"" + resource.getURI() + "\"";
            }
            return "rdf:resource=\"" + resource.getURI() + "\"";
        }
        String key = isReferenced ? (referencedAsNode ? "rdf:about" : "rdf:resource") : "rdf:about";
        String value = null;
        String abbreviation = null;
        URIReference uri = (URIReference)resource.getUriRef().get(0);
        value = uri.getNamespace() != null ? ((abbreviation = (String)this.NamespaceHashTable.get(uri.getNamespace().getNamespaceURIRef().getURIString())) != null && uri.getNamespace().getNamespaceURIRef().getURIString().indexOf("%") == -1 ? "&" + abbreviation + ";" + uri.getFragmentIdentifier().getName() : resource.getURI()) : resource.getURI();
        return String.valueOf(key) + "=\"" + value + "\"";
    }

    private void writeAttribute(String name, RDFSResource value) throws IOException, UnsupportedViewTypeException {
        block109: {
            block108: {
                block107: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFSLiteral");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (value.canAsType((Class)clazz)) {
                        this.writeIndents(0);
                        Class<?> clazz2 = class$27;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$27 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (value.canAsType((Class)clazz2)) {
                            this.writer.write("<" + name + " rdf:parseType=\"Literal\">" + ((RDFSLiteral)value).getLexicalForm());
                        } else {
                            Class<?> clazz3 = class$28;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$28 = Class.forName("org.eclipse.eodm.rdf.rdfbase.TypedLiteral");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (value.canAsType((Class)clazz3)) {
                                this.writer.write("<" + name + " rdf:datatype=\"" + ((TypedLiteral)value).getDatatypeURI().getURIString() + "\">" + ((RDFSLiteral)value).getLexicalForm());
                            } else {
                                Class<?> clazz4 = class$29;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = class$29 = Class.forName("org.eclipse.eodm.rdf.rdfbase.PlainLiteral");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (value.canAsType((Class)clazz4)) {
                                    String lang = ((PlainLiteral)value).getLanguage();
                                    if (lang != null && lang.length() > 0) {
                                        this.writer.write("<" + name + " xml:lang=\"" + lang + "\">" + ((RDFSLiteral)value).getLexicalForm());
                                    } else {
                                        this.writer.write("<" + name + ">" + ((RDFSLiteral)value).getLexicalForm());
                                    }
                                } else {
                                    this.writer.write("<" + name + ">" + ((RDFSLiteral)value).getLexicalForm());
                                }
                            }
                        }
                        this.writer.write("</" + name + ">\n");
                        return;
                    }
                    Class<?> clazz5 = class$3;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (value.canAsType((Class)clazz5)) break block107;
                    Class<?> clazz6 = class$11;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$11 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDataRange");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!value.canAsType((Class)clazz6)) break block108;
                }
                if (!this.isAnonymousElement(value) && (this.isAnonymousElement(value) || value.getURI() == null || value.getURI().length() <= 0)) break block109;
            }
            if (!this.isAnonymousElement(value) || this.isAnonymousElement(value) && this.usedElements.containsKey(value.getNodeID())) {
                this.writeIndents(0);
                this.writer.write("<" + name + " " + this.getIDAttr(value, true, false) + "/>\n");
                return;
            }
        }
        this.writeIndents(1);
        this.writer.write("<" + name + ">\n");
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (value.canAsType((Class)clazz)) {
            Class<?> clazz7 = class$3;
            if (clazz7 == null) {
                try {
                    clazz7 = class$3 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.writeClass((OWLClass)value.asType((Class)clazz7), true, true);
        } else {
            Class<?> clazz8 = class$4;
            if (clazz8 == null) {
                try {
                    clazz8 = class$4 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (value.canAsType((Class)clazz8)) {
                Class<?> clazz9 = class$4;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$4 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLObjectProperty");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeObjProperty((OWLObjectProperty)value.asType((Class)clazz9), true, true);
            } else {
                Class<?> clazz10 = class$5;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$5 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (value.canAsType((Class)clazz10)) {
                    Class<?> clazz11 = class$5;
                    if (clazz11 == null) {
                        try {
                            clazz11 = class$5 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.writeDatatypeProperty((OWLDatatypeProperty)value.asType((Class)clazz11), true, true);
                } else {
                    Class<?> clazz12 = class$8;
                    if (clazz12 == null) {
                        try {
                            clazz12 = class$8 = Class.forName("org.eclipse.eodm.owl.owlbase.Individual");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (value.canAsType((Class)clazz12)) {
                        Class<?> clazz13 = class$8;
                        if (clazz13 == null) {
                            try {
                                clazz13 = class$8 = Class.forName("org.eclipse.eodm.owl.owlbase.Individual");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.writeIndividual((Individual)value.asType((Class)clazz13), true, true);
                    } else {
                        Class<?> clazz14 = class$10;
                        if (clazz14 == null) {
                            try {
                                clazz14 = class$10 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFStatement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (value.canAsType((Class)clazz14)) {
                            Class<?> clazz15 = class$10;
                            if (clazz15 == null) {
                                try {
                                    clazz15 = class$10 = Class.forName("org.eclipse.eodm.rdf.rdfbase.RDFStatement");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.writeStatement((RDFStatement)value.asType((Class)clazz15), true, true);
                        } else {
                            Class<?> clazz16 = class$9;
                            if (clazz16 == null) {
                                try {
                                    clazz16 = class$9 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFSContainer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (value.canAsType((Class)clazz16)) {
                                Class<?> clazz17 = class$9;
                                if (clazz17 == null) {
                                    try {
                                        clazz17 = class$9 = Class.forName("org.eclipse.eodm.rdf.rdfs.RDFSContainer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.writeContainer((RDFSContainer)value.asType((Class)clazz17), true, true);
                            } else {
                                Class<?> clazz18 = class$11;
                                if (clazz18 == null) {
                                    try {
                                        clazz18 = class$11 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDataRange");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (value.canAsType((Class)clazz18)) {
                                    Class<?> clazz19 = class$11;
                                    if (clazz19 == null) {
                                        try {
                                            clazz19 = class$11 = Class.forName("org.eclipse.eodm.owl.owlbase.OWLDataRange");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.writeDataRange((OWLDataRange)value.asType((Class)clazz19), true, true);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.writeIndents(-1);
        this.writer.write("</" + name + ">\n");
    }

    private void writeAttributes(String name, EList values) throws IOException, UnsupportedViewTypeException {
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            this.writeAttribute(name, (RDFSResource)iterator.next());
        }
    }

    static String replaceKeywords(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }
}

