/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.statemachine.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class TransitionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public TransitionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Transition)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Vertex) || !(this.newEnd instanceof Vertex)) {
            return false;
        }
        Vertex target = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof Region)) {
            return false;
        }
        Region container = (Region)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistTransition_4001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Vertex) || !(this.newEnd instanceof Vertex)) {
            return false;
        }
        Vertex source = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof Region)) {
            return false;
        }
        Region container = (Region)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistTransition_4001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Transition getLink() {
        return (Transition)this.getElementToEdit();
    }

    protected Vertex getOldSource() {
        return (Vertex)this.oldEnd;
    }

    protected Vertex getNewSource() {
        return (Vertex)this.newEnd;
    }

    protected Vertex getOldTarget() {
        return (Vertex)this.oldEnd;
    }

    protected Vertex getNewTarget() {
        return (Vertex)this.newEnd;
    }
}

