/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St1MinPosIsCalculated;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.state.St9LifelineFinished;

public class LifelineState {
    private static final boolean DEBUG_SAVE_POS = false;
    private static final boolean DEBUG_LOAD_POS = false;
    private final LifeLine myLifeLine;
    private int myBase;
    private HorizontalConstraint myRequiredHorizontalConstraint;
    private boolean myHorizontalConstraintCalculated = false;
    private final Set myRequiredOrderingConstraints = new HashSet(3);
    private final Map myEncounteredOrderingConstraints2Pos = new HashMap(3);
    private ElementWrapper myCurrentWrapper;
    private final List myWrapperList;
    private int myIndex;
    private final Map myBrokenHorizontalConstraints2Counter = new HashMap(2);
    private final Set myBrokenOrderingConstraints;
    private Class myState;
    private int myBeforeConstraintPos;

    public LifelineState(LifeLine lifeLine, int topPos, boolean resetPositions, Set brokenOrderingConstraints) {
        this.myLifeLine = lifeLine;
        this.myBase = topPos;
        this.myWrapperList = new ArrayList();
        this.myBrokenOrderingConstraints = brokenOrderingConstraints;
        int priorityCounter = 0;
        LifeLineIterator it = lifeLine.iterator();
        while (it.hasNext()) {
            it.nextClueValue();
            LifeLineElement element = it.nextElement();
            if (resetPositions) {
                element.optimizeSize();
            }
            if (element.getPosition().isFirstPrioritedPosition()) {
                ++priorityCounter;
            }
            this.myWrapperList.add(new ElementWrapper(element, priorityCounter > 0));
            if (!element.getPosition().isLastPrioritedPosition()) continue;
            --priorityCounter;
        }
        this.myIndex = -1;
        if (resetPositions) {
            this.resetPositions(topPos);
        } else {
            this.loadPositions(topPos);
        }
        this.nextStep();
        this.myState = this.isFinished() ? St9LifelineFinished.class : St1MinPosIsCalculated.class;
    }

    public String getStateStringDebug() {
        return "element=" + this.myCurrentWrapper.getElement();
    }

    public String toString() {
        return "LifelineState<" + this.myLifeLine + ">";
    }

    private void loadPositions(int topPos) {
        ElementWrapper firstElementWrapper = (ElementWrapper)this.myWrapperList.get(0);
        firstElementWrapper.setPos(topPos);
        int i = 1;
        while (i < this.myWrapperList.size()) {
            ElementWrapper elementWrapper = (ElementWrapper)this.myWrapperList.get(i);
            elementWrapper.loadPos();
            ++i;
        }
    }

    private void resetPositions(int topPos) {
        int i = 0;
        while (i < this.myWrapperList.size()) {
            ElementWrapper elementWrapper = (ElementWrapper)this.myWrapperList.get(i);
            elementWrapper.setPos(topPos);
            ++i;
        }
    }

    public void savePositions() {
        assert (this.checkPositionsMonotonous());
        int i = 0;
        while (i < this.myWrapperList.size()) {
            ElementWrapper elementWrapper = (ElementWrapper)this.myWrapperList.get(i);
            elementWrapper.savePos();
            ++i;
        }
        assert (this.checkPositionsSaved());
    }

    private boolean checkPositionsMonotonous() {
        ElementWrapper firstElementWrapper = (ElementWrapper)this.myWrapperList.get(0);
        LifeLineElement firstElement = firstElementWrapper.getElement();
        int base = firstElementWrapper.getPos() - firstElement.getPointOffset() + firstElement.getSize();
        int i = 1;
        while (i < this.myWrapperList.size()) {
            ElementWrapper elementWrapper = (ElementWrapper)this.myWrapperList.get(i);
            LifeLineElement element = elementWrapper.getElement();
            int pos = elementWrapper.getPos();
            if (pos < base) {
                throw new RuntimeException(String.valueOf(pos) + " < " + base);
            }
            base = pos - element.getPointOffset() + element.getSize();
            ++i;
        }
        return true;
    }

    private boolean checkPositionsSaved() {
        int i = 0;
        while (i < this.myWrapperList.size()) {
            ElementWrapper elementWrapper = (ElementWrapper)this.myWrapperList.get(i);
            elementWrapper.assertSaved();
            ++i;
        }
        return true;
    }

    void nextStep() {
        if (this.hasRequired()) {
            throw new IllegalStateException("Lifeline is blocked");
        }
        if (this.myCurrentWrapper != null) {
            this.goodbyeElement();
        }
        if (this.myIndex + 1 >= this.myWrapperList.size()) {
            this.myCurrentWrapper = null;
            return;
        }
        ++this.myIndex;
        this.myCurrentWrapper = (ElementWrapper)this.myWrapperList.get(this.myIndex);
        this.hoorayElement();
    }

    private void goodbyeElement() {
        this.myBeforeConstraintPos = 0;
    }

    private void hoorayElement() {
        Enumeration<OrderingConstraint> constrEnum = this.myCurrentWrapper.getElement().beforeConstraints();
        while (constrEnum.hasMoreElements()) {
            OrderingConstraint constraint = constrEnum.nextElement();
            this.myRequiredOrderingConstraints.add(constraint);
        }
    }

    public Class getState() {
        return this.myState;
    }

    void setState(Class state) {
        this.myState = state;
    }

    boolean isFinished() {
        return this.myCurrentWrapper == null;
    }

    HorizontalConstraint getHorizontalConstraint() {
        assert (this.myHorizontalConstraintCalculated);
        return this.myRequiredHorizontalConstraint;
    }

    Set getRequiredOrderingConstraints() {
        return this.myRequiredOrderingConstraints;
    }

    public Map getEncounteredOrderingConstraints2Pos() {
        return this.myEncounteredOrderingConstraints2Pos;
    }

    private boolean hasRequired() {
        return this.myHorizontalConstraintCalculated || !this.myRequiredOrderingConstraints.isEmpty();
    }

    void setCurrentPos(int pos) {
        if (pos < this.getMinPos()) {
            throw new IllegalArgumentException("pos is too small");
        }
        this.myCurrentWrapper.setPos(pos);
        this.myBase = pos + this.myCurrentWrapper.getPostSize();
    }

    int getMinPos() {
        return this.myBase + this.myCurrentWrapper.getPreSize();
    }

    int getCurrentPos() {
        if (this.myCurrentWrapper.isVirtual()) {
            return this.getMinPos();
        }
        int result = this.myCurrentWrapper.getPos();
        return result;
    }

    int getBase() {
        return this.myBase;
    }

    boolean isPrioritedPosition() {
        return this.myCurrentWrapper.isPriorited();
    }

    void addEncounteredAfterConstraints() {
        Enumeration<OrderingConstraint> constrEnum = this.myCurrentWrapper.getElement().afterConstraints();
        while (constrEnum.hasMoreElements()) {
            OrderingConstraint constraint = constrEnum.nextElement();
            if (this.myBrokenOrderingConstraints.remove(constraint)) continue;
            this.myEncounteredOrderingConstraints2Pos.put(constraint, new Integer(this.myCurrentWrapper.getPos()));
        }
    }

    public void dismissRequiredHorizontalConstraint() {
        this.myHorizontalConstraintCalculated = false;
        this.myRequiredHorizontalConstraint = null;
    }

    public void addBrokenHorizontalConstraints(HorizontalConstraint constraint) {
        Counter counter = (Counter)this.myBrokenHorizontalConstraints2Counter.get(constraint);
        if (counter == null) {
            counter = new Counter();
            this.myBrokenHorizontalConstraints2Counter.put(constraint, counter);
        }
        counter.increase();
    }

    int getBeforeConstraintPos() {
        return this.myBeforeConstraintPos;
    }

    void setBeforeConstraintPos(int beforeConstraintPos) {
        this.myBeforeConstraintPos = beforeConstraintPos;
    }

    public LifeLineElement getCurrentElement() {
        return this.myCurrentWrapper.getElement();
    }

    void prepareHorizontalConstraint() {
        Counter counter;
        assert (!this.myHorizontalConstraintCalculated);
        this.myRequiredHorizontalConstraint = this.myCurrentWrapper.getElement().getHorizontalConstraint();
        if (this.myRequiredHorizontalConstraint != null && (counter = (Counter)this.myBrokenHorizontalConstraints2Counter.get(this.myRequiredHorizontalConstraint)) != null && counter.getCount() > 0) {
            this.myRequiredHorizontalConstraint = null;
            counter.decrease();
        }
        this.myHorizontalConstraintCalculated = true;
    }

    private static class Counter {
        int myInt = 0;

        private Counter() {
        }

        void increase() {
            ++this.myInt;
        }

        void decrease() {
            --this.myInt;
        }

        int getCount() {
            return this.myInt;
        }
    }

    static class ElementWrapper {
        private final LifeLineElement myElement;
        private final boolean myIsPriorited;
        private int myPos;

        ElementWrapper(LifeLineElement element, boolean isPriorited) {
            this.myElement = element;
            this.myIsPriorited = isPriorited;
        }

        void loadPos() {
            this.myPos = this.myElement.getPosition().getPositionValue();
        }

        void savePos() {
            this.myElement.getPosition().setPositionValue(this.myPos);
        }

        void assertSaved() {
            assert (this.isVirtual() || this.myElement.getPosition().getPositionValue() == this.myPos);
        }

        boolean isVirtual() {
            return this.myElement.getPosition().isVirtual();
        }

        int getPreSize() {
            return this.myElement.getPointOffset();
        }

        int getPostSize() {
            return this.myElement.getSize() - this.myElement.getPointOffset();
        }

        int getPos() {
            return this.myPos;
        }

        void setPos(int pos) {
            this.myPos = pos;
        }

        boolean isPriorited() {
            return this.myIsPriorited;
        }

        LifeLineElement getElement() {
            return this.myElement;
        }
    }
}

