/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource;

import java.io.InputStream;
import org.eclipse.eodm.owl.resource.parser.OWLParser;
import org.eclipse.eodm.owl.resource.parser.exception.OWLParserException;
import org.eclipse.eodm.owl.resource.parser.impl.OWLDocumentImpl;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserImpl;

public final class OWLXMLLoader {
    private static OWLParser parser = new OWLParserImpl();

    private OWLXMLLoader() {
    }

    public static void addFile(String fileName, String publicURI, boolean localFile) throws OWLParserException {
        OWLXMLLoader.addFile(fileName, publicURI, localFile, null);
    }

    public static void addFile(String fileName, String publicURI, boolean localFile, String charset) throws OWLParserException {
        OWLDocumentImpl document = new OWLDocumentImpl(fileName, publicURI, localFile);
        document.setCharset(charset);
        parser.addOWLDocument(document);
    }

    public static OWLOntologyGraph[] loadFromStream(InputStream inputstream) throws OWLParserException {
        return OWLXMLLoader.loadFromStream(inputstream, null);
    }

    public static OWLOntologyGraph[] loadFromStream(InputStream inputstream, String charset) throws OWLParserException {
        OWLDocumentImpl document = new OWLDocumentImpl(inputstream);
        document.setCharset(charset);
        parser.addOWLDocument(document);
        OWLOntologyGraph[] onto = parser.parseOWLDocument(document);
        parser.clear();
        return onto;
    }

    public static OWLOntologyGraph[] loadOntology(String filename) throws OWLParserException {
        OWLOntologyGraph[] onto = parser.parseOWLDocument(filename);
        return onto;
    }

    public static OWLOntologyGraph[] loadOntologyFromFile(String filename, String publicURI, boolean localFile, String charset) throws OWLParserException {
        OWLDocumentImpl document = new OWLDocumentImpl(filename, publicURI, localFile);
        document.setCharset(charset);
        parser.addOWLDocument(document);
        OWLOntologyGraph[] onto = parser.parseOWLDocument(document);
        parser.clear();
        return onto;
    }

    public static void clear() {
        parser.clear();
    }
}

