/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.reasoner.structural;

import java.util.List;
import org.eclipse.eodm.owl.reasoner.structural.AllValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.Cardinality;
import org.eclipse.eodm.owl.reasoner.structural.Concept;
import org.eclipse.eodm.owl.reasoner.structural.HasValue;
import org.eclipse.eodm.owl.reasoner.structural.Individual;
import org.eclipse.eodm.owl.reasoner.structural.Intersection;
import org.eclipse.eodm.owl.reasoner.structural.Literal;
import org.eclipse.eodm.owl.reasoner.structural.MaxCardinality;
import org.eclipse.eodm.owl.reasoner.structural.MinCardinality;
import org.eclipse.eodm.owl.reasoner.structural.Negation;
import org.eclipse.eodm.owl.reasoner.structural.ObjectProp;
import org.eclipse.eodm.owl.reasoner.structural.PrimitiveConcept;
import org.eclipse.eodm.owl.reasoner.structural.ReasonerUtil;
import org.eclipse.eodm.owl.reasoner.structural.Resource;
import org.eclipse.eodm.owl.reasoner.structural.Role;
import org.eclipse.eodm.owl.reasoner.structural.SomeValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.Union;

public class TermFactory {
    private static TermFactory instance = new TermFactory();

    public static TermFactory instance() {
        return instance;
    }

    public Role createRole(String id) {
        return new Role(id);
    }

    public ObjectProp createObjectProp(String id) {
        return new ObjectProp(id);
    }

    public Individual createIndividual(String id) {
        return new Individual(id);
    }

    public Literal createLiteral(String lexicalForm) {
        return new Literal(lexicalForm);
    }

    public PrimitiveConcept createPrim(String id) {
        return new PrimitiveConcept(id);
    }

    public Negation createNegation(Concept c) {
        Negation term = new Negation(c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Intersection createIntersect() {
        Intersection term = new Intersection(null);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Intersection createIntersect(List clist) {
        Intersection term = new Intersection(clist);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Intersection createIntersect(Concept c1, Concept c2) {
        Intersection term = new Intersection(c1, c2);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Union createUnion() {
        Union term = new Union(null);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Union createUnion(List clist) {
        Union term = new Union(clist);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Union createUnion(Concept c1, Concept c2) {
        Union term = new Union(c1, c2);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public SomeValueFrom createSome(Role p, Concept c) {
        SomeValueFrom term = new SomeValueFrom(p, c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public AllValueFrom createAll(Role p, Concept c) {
        AllValueFrom term = new AllValueFrom(p, c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public HasValue createHasValue(Role p, Resource r) {
        HasValue term = new HasValue(p, r);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public Cardinality createCardinality(Role p, int val, Concept c) {
        Cardinality term = new Cardinality(p, val, c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public MaxCardinality createMaxCardinality(Role p, int val, Concept c) {
        MaxCardinality term = new MaxCardinality(p, val, c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }

    public MinCardinality createMinCardinality(Role p, int val, Concept c) {
        MinCardinality term = new MinCardinality(p, val, c);
        term.setName(ReasonerUtil.toString(term));
        return term;
    }
}

