/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.examples.owl;

import java.io.IOException;
import org.eclipse.eodm.owl.AllValuesFromRestriction;
import org.eclipse.eodm.owl.ComplementClass;
import org.eclipse.eodm.owl.EnumeratedClass;
import org.eclipse.eodm.owl.HasValueRestriction;
import org.eclipse.eodm.owl.Individual;
import org.eclipse.eodm.owl.IntersectionClass;
import org.eclipse.eodm.owl.MinCardinalityRestriction;
import org.eclipse.eodm.owl.OWLClass;
import org.eclipse.eodm.owl.OWLDataRange;
import org.eclipse.eodm.owl.OWLDatatypeProperty;
import org.eclipse.eodm.owl.OWLFactory;
import org.eclipse.eodm.owl.OWLObjectProperty;
import org.eclipse.eodm.owl.OWLOntology;
import org.eclipse.eodm.owl.Property;
import org.eclipse.eodm.owl.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.UnionClass;
import org.eclipse.eodm.owl.resource.OWLXMLSaver;
import org.eclipse.eodm.rdfs.Namespace;
import org.eclipse.eodm.rdfs.Ontology;
import org.eclipse.eodm.rdfs.PlainLiteral;
import org.eclipse.eodm.rdfs.RDFProperty;
import org.eclipse.eodm.rdfs.RDFSClass;
import org.eclipse.eodm.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdfs.RDFSFactory;
import org.eclipse.eodm.rdfs.RDFSLiteral;
import org.eclipse.eodm.rdfs.RDFSResource;
import org.eclipse.eodm.rdfs.TypedLiteral;
import org.eclipse.eodm.rdfs.vocabulary.XSD;

public class CreateAndManipulateOWLExample {
    private OWLOntology ontology;

    public static void main(String[] args) {
        CreateAndManipulateOWLExample test = new CreateAndManipulateOWLExample();
        test.createOntology();
        test.saveOntology("testcase/test.owl");
    }

    public void createOntology() {
        OWLFactory factory = OWLFactory.eINSTANCE;
        this.ontology = factory.createOWLOntology();
        this.ontology.setLocalName("TestOntology");
        Namespace test = RDFSFactory.eINSTANCE.createNamespace((Ontology)this.ontology, "test", "http://test.org/test#");
        this.ontology.setNamespace(test);
        Namespace xsd = RDFSFactory.eINSTANCE.createNamespace((Ontology)this.ontology, "xsd", "http://www.w3.org/2001/XMLSchema#");
        RDFSDatatype xsd_nonNegativeInteger = RDFSFactory.eINSTANCE.createRDFSDatatype((Ontology)this.ontology, XSD.snonNegativeInteger, xsd);
        RDFSDatatype xsd_string = RDFSFactory.eINSTANCE.createRDFSDatatype((Ontology)this.ontology, XSD.sxstring, xsd);
        Namespace otherOntNS = RDFSFactory.eINSTANCE.createNamespace((Ontology)this.ontology, "otherOnt", "http://foo.org/otherOntology#");
        OWLClass Person = factory.createOWLClass(this.ontology, "Person");
        OWLClass Employee = factory.createOWLClass(this.ontology, "Employee");
        OWLClass GraduateStudent = factory.createOWLClass(this.ontology, "GraduateStudent");
        OWLClass Org = factory.createOWLClass(this.ontology, "Organization");
        OWLClass Course = factory.createOWLClass(this.ontology, "Course");
        OWLClass GraduateCourse = factory.createOWLClass(this.ontology, "GraduateCourse");
        Person.getSubClass().add((Object)Employee);
        Course.getSubClass().add((Object)GraduateCourse);
        OWLClass Sports = factory.createOWLClass(this.ontology, "Sports");
        OWLClass BasketBallLover = factory.createOWLClass(this.ontology, "BasketBallLover");
        Individual basketball = factory.createIndividual(this.ontology, "BasketBall", Sports);
        Individual aPerson1 = factory.createIndividual(this.ontology, "Person1", Person);
        Individual aPerson2 = factory.createIndividual(this.ontology, "Person2", Person);
        Individual aPerson3 = factory.createIndividual(this.ontology, "Person3", Person);
        OWLObjectProperty worksFor = factory.createOWLObjectProperty(this.ontology, "worksFor");
        OWLObjectProperty takesCourse = factory.createOWLObjectProperty(this.ontology, "takesCourse");
        OWLObjectProperty like = factory.createOWLObjectProperty(this.ontology, "like");
        OWLObjectProperty hasSameHometownWith = factory.createOWLObjectProperty(this.ontology, "hasSameHometownWith");
        OWLObjectProperty isHeadOf = factory.createOWLObjectProperty(this.ontology, "isHeadOf");
        worksFor.getSubProperty().add((Object)isHeadOf);
        OWLObjectProperty leadBy = factory.createOWLObjectProperty(this.ontology, "leadBy");
        OWLDatatypeProperty firstName = factory.createOWLDatatypeProperty(this.ontology, "firstName");
        firstName.getRDFSDomain().add((Object)Person);
        firstName.getRDFSRange().add((Object)xsd_string);
        TypedLiteral fname = RDFSFactory.eINSTANCE.createTypedLiteral((Ontology)this.ontology, "John", xsd_string);
        aPerson1.addPropertyValue((RDFProperty)firstName, (RDFSResource)fname);
        aPerson1.addPropertyValue((RDFProperty)like, (RDFSResource)basketball);
        isHeadOf.setInverseFunctional(Boolean.TRUE);
        firstName.setFunctional(Boolean.TRUE);
        like.setSymmetric(Boolean.TRUE);
        like.setTransitive(Boolean.FALSE);
        hasSameHometownWith.setTransitive(Boolean.TRUE);
        isHeadOf.getInvOWLInverseOf().add((Object)leadBy);
        AllValuesFromRestriction avfr = factory.createAllValuesFromRestriction(this.ontology, (Property)takesCourse, (RDFSClass)GraduateCourse);
        avfr.getSubClass().add((Object)GraduateStudent);
        SomeValuesFromRestriction svfr = factory.createSomeValuesFromRestriction(this.ontology, (Property)worksFor, (RDFSClass)Org);
        TypedLiteral liter = RDFSFactory.eINSTANCE.createTypedLiteral((Ontology)this.ontology, "1", xsd_nonNegativeInteger);
        MinCardinalityRestriction mcr = factory.createMinCardinalityRestriction(this.ontology, (Property)takesCourse, (RDFSLiteral)liter);
        mcr.getSubClass().add((Object)GraduateStudent);
        HasValueRestriction hvr = factory.createHasValueRestriction(this.ontology, (Property)like, (RDFSResource)basketball);
        hvr.getSubClass().add((Object)BasketBallLover);
        OWLClass Human = factory.createOWLClass(this.ontology, "Human");
        Person.getOWLEquivalentClass().add((Object)Human);
        OWLObjectProperty love = factory.createOWLObjectProperty(this.ontology, "love");
        love.getOWLEquivalentProperty().add((Object)like);
        aPerson1.getOWLSameAs().add((Object)aPerson2);
        aPerson1.getOWLDifferentFrom().add((Object)aPerson3);
        IntersectionClass intc = factory.createIntersectionClass(this.ontology, null);
        intc.getOWLIntersectionOf().add((Object)svfr);
        intc.getOWLIntersectionOf().add((Object)Person);
        Employee.getRDFSSubClassOf().add((Object)intc);
        OWLClass Man = factory.createOWLClass(this.ontology, "Man");
        OWLClass Woman = factory.createOWLClass(this.ontology, "Woman");
        UnionClass uc = factory.createUnionClass(this.ontology, "Human");
        uc.getOWLUnionOf().add((Object)Man);
        uc.getOWLUnionOf().add((Object)Woman);
        ComplementClass cc = factory.createComplementClass(this.ontology, null, Woman);
        Man.getOWLEquivalentClass().add((Object)cc);
        EnumeratedClass ec = factory.createEnumeratedClass(this.ontology, null);
        ec.getOWLOneOf().add((Object)aPerson1);
        ec.getOWLOneOf().add((Object)aPerson2);
        ec.getOWLOneOf().add((Object)aPerson3);
        Person.getOWLEquivalentClass().add((Object)ec);
        PlainLiteral pl_male = RDFSFactory.eINSTANCE.createPlainLiteral((Ontology)this.ontology, "MALE", "EN");
        PlainLiteral pl_female = RDFSFactory.eINSTANCE.createPlainLiteral((Ontology)this.ontology, "FEMALE", "EN");
        OWLDataRange dr = factory.createOWLDataRange(this.ontology, "Gender");
        dr.getOWLOneOf().add((Object)pl_male);
        dr.getOWLOneOf().add((Object)pl_female);
        Person.getOWLDisjointWith().add((Object)Course);
        Person.getOWLDisjointWith().add((Object)Sports);
        Person.getOWLDisjointWith().add((Object)Org);
        PlainLiteral PersonLabel = RDFSFactory.eINSTANCE.createPlainLiteral((Ontology)this.ontology, "Person", "EN");
        Person.getRDFSLabel().add((Object)PersonLabel);
        PlainLiteral PersonComment = RDFSFactory.eINSTANCE.createPlainLiteral();
        PersonComment.setLexicalForm("Person Class represents the top class of Man and Woman");
        Person.getRDFSComment().add((Object)PersonComment);
        RDFSResource res = RDFSFactory.eINSTANCE.createRDFSResource((Ontology)this.ontology, "A_Resource");
        Person.getRDFSSeeAlso().add((Object)res);
        Person.getRDFSIsDefinedBy().add((Object)res);
        PlainLiteral version = RDFSFactory.eINSTANCE.createPlainLiteral();
        version.setLexicalForm("version 1.01 2005/06/27 12:56:51 lsp");
        this.ontology.getOWLVersionInfo().add((Object)version);
        OWLOntology otherOnt = OWLFactory.eINSTANCE.createOWLOntology();
        otherOnt.setLocalName("");
        otherOnt.setNamespace(otherOntNS);
        this.ontology.getOWLBackwardCompatibleWith().add((Object)otherOnt);
        this.ontology.getOWLIncompatibleWith().add((Object)otherOnt);
        this.ontology.getOWLPriorVersion().add((Object)otherOnt);
        Human.setDeprecated(Boolean.TRUE);
        love.setDeprecated(Boolean.TRUE);
        System.out.println("OK");
    }

    public void saveOntology(String fileName) {
        try {
            OWLXMLSaver.saveToFile((OWLOntology)this.ontology, (String)fileName, (String)"UTF-8");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

