/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionEditPolicy;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.usecase.draw2d.StickMan;
import org.eclipse.uml2.diagram.usecase.edit.parts.ActorNameEditPart;
import org.eclipse.uml2.diagram.usecase.edit.policies.ActorItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.usecase.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorEditPart
extends AbstractBorderedShapeEditPart {
    public static final int VISUAL_ID = 2002;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private LinkTargetListener myLinkTargetListener;

    public ActorEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        if (UMLVisualIDRegistry.isShortcutDescendant(this.getNotationView())) {
            this.installEditPolicy(UpdateDescriptionEditPolicy.ROLE, (EditPolicy)new UpdateDescriptionEditPolicy(UMLDiagramUpdater.TYPED_ADAPTER, true));
        }
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActorItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new BorderItemSelectionEditPolicy();
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StickMan();
        return this.primaryShape;
    }

    public StickMan getPrimaryShape() {
        return (StickMan)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof ActorNameEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 4);
            locator.setBorderItemOffset(new Dimension(-20, -20));
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(30), this.getMapMode().DPtoLP(50));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5002));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
        this.handleTypeLinkModification(event);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private LinkTargetListener getLinkTargetListener() {
        if (this.myLinkTargetListener == null) {
            this.myLinkTargetListener = new LinkTargetListener();
        }
        return this.myLinkTargetListener;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        for (IUpdaterNodeDescriptor iUpdaterNodeDescriptor : this.getActor_2002ContainedLinks()) {
            EObject nextLink = iUpdaterNodeDescriptor.getModelElement();
            if (nextLink == null) continue;
            switch (iUpdaterNodeDescriptor.getVisualID()) {
                case 4003: {
                    this.getLinkTargetListener().addReferenceListener(nextLink, (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General());
                    break;
                }
            }
        }
    }

    private List<IUpdaterLinkDescriptor> getActor_2002ContainedLinks() {
        return UMLDiagramUpdater.getActor_2002ContainedLinks(this.getNotationView());
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.getLinkTargetListener().dispose();
    }

    private void handleTypeLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getClassifier_Generalization()) {
            block0 : switch (event.getEventType()) {
                case 3: {
                    Object link = event.getNewValue();
                    if (link instanceof Generalization) {
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General());
                    }
                    if (!(link instanceof Generalization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 4: {
                    Object link = event.getOldValue();
                    if (link instanceof Generalization) {
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General());
                    }
                    if (!(link instanceof Generalization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 5: {
                    List links = (List)event.getNewValue();
                    for (Object link : links) {
                        if (!(link instanceof Generalization)) continue;
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Generalization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    List links = (List)event.getOldValue();
                    for (Object link : links) {
                        if (!(link instanceof Generalization)) continue;
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getGeneralization_General());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Generalization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public void refreshDiagram() {
        UMLDiagramUpdateCommand.performCanonicalUpdate(this.getDiagramView().getElement());
    }

    private class LinkTargetListener
    implements NotificationListener {
        Map<EObject, Set<EStructuralFeature>> myNotifiers = new HashMap<EObject, Set<EStructuralFeature>>();

        private LinkTargetListener() {
        }

        private void added(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                this.myNotifiers.put(link, new HashSet());
            }
            this.myNotifiers.get(link).add(feature);
        }

        private void removed(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                return;
            }
            this.myNotifiers.get(link).remove(feature);
        }

        public void dispose() {
            Set<Map.Entry<EObject, Set<EStructuralFeature>>> entrySet = this.myNotifiers.entrySet();
            for (Map.Entry<EObject, Set<EStructuralFeature>> entry : entrySet) {
                for (EStructuralFeature feature : entry.getValue()) {
                    ActorEditPart.this.getDiagramEventBroker().removeNotificationListener(entry.getKey(), (Object)feature, (NotificationListener)this);
                }
            }
        }

        private void removeReferenceListener(EObject link, EStructuralFeature feature) {
            ActorEditPart.this.getDiagramEventBroker().removeNotificationListener(link, (Object)feature, (NotificationListener)this);
            this.removed(link, feature);
        }

        private void addReferenceListener(EObject link, EStructuralFeature feature) {
            ActorEditPart.this.getDiagramEventBroker().addNotificationListener(link, feature, (NotificationListener)this);
            this.added(link, feature);
        }

        public void notifyChanged(Notification event) {
            if (event.getFeature() == UMLPackage.eINSTANCE.getGeneralization_General()) {
                ActorEditPart.this.refreshDiagram();
                return;
            }
        }
    }
}

