/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.uml2.diagram.sequence.edit.policies.InteractionNestedLayoutRequest;
import org.eclipse.uml2.diagram.sequence.internal.layout.manage.SdLayoutAsInnerLayout;

public class InteractionNestedLayoutEditPolicy
extends AbstractEditPolicy {
    private SdLayoutAsInnerLayout mySdLayout;
    private EditPartTracker myEditPartTracker;

    public void activate() {
        this.reinitSDLayout();
        try {
            InteractionNestedLayoutRequest req = new InteractionNestedLayoutRequest();
            this.getHostImpl().getDiagramEditDomain().getDiagramCommandStack().execute(this.getCommand(req));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void reinitSDLayout() {
        this.myEditPartTracker = new EditPartTracker();
        this.mySdLayout = new SdLayoutAsInnerLayout(this.getHostImpl());
        this.getHost().addEditPartListener((EditPartListener)this.myEditPartTracker);
        this.setupNodesTree((EditPart)this.getHostImpl());
        this.setupLinksTree((EditPart)this.getHostImpl());
    }

    private void setupNodesTree(EditPart treeRoot) {
        for (Object next : treeRoot.getChildren()) {
            EditPart nextEP = (EditPart)next;
            this.addToLayout(nextEP);
            nextEP.addEditPartListener((EditPartListener)this.myEditPartTracker);
            if (nextEP instanceof NodeEditPart) {
                ((NodeEditPart)nextEP).addNodeListener((NodeListener)this.myEditPartTracker);
            }
            this.setupNodesTree(nextEP);
        }
    }

    private void setupLinksTree(EditPart treeRoot) {
        for (Object next : treeRoot.getChildren()) {
            if (next instanceof NodeEditPart) {
                NodeEditPart nextEP = (NodeEditPart)next;
                for (Object nextLink : nextEP.getSourceConnections()) {
                    if (!(nextLink instanceof ConnectionEditPart)) continue;
                    this.addToLayout((EditPart)((ConnectionEditPart)nextLink));
                }
            }
            this.setupLinksTree((EditPart)next);
        }
    }

    public void deactivate() {
        this.mySdLayout = null;
        this.getHost().removeEditPartListener((EditPartListener)this.myEditPartTracker);
    }

    public boolean understandsRequest(Request req) {
        if (req instanceof ArrangeRequest) {
            return true;
        }
        return req instanceof InteractionNestedLayoutRequest;
    }

    public Command getCommand(Request request) {
        if (request instanceof ArrangeRequest) {
            return this.getNestedLayoutCommand(new InteractionNestedLayoutRequest());
        }
        if (request instanceof InteractionNestedLayoutRequest) {
            return this.getNestedLayoutCommand((InteractionNestedLayoutRequest)request);
        }
        return null;
    }

    protected Command getNestedLayoutCommand(final InteractionNestedLayoutRequest request) {
        AbstractTransactionalCommand result = new AbstractTransactionalCommand(this.getHostImpl().getEditingDomain(), "Layouting", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)this.getHostImpl().getNotationView().eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (request.isTotalLayout()) {
                    InteractionNestedLayoutEditPolicy.this.mySdLayout = null;
                    InteractionNestedLayoutEditPolicy.this.reinitSDLayout();
                }
                for (IAdaptable nextViewAdapter : request.getViewAdapters()) {
                    View view = (View)nextViewAdapter.getAdapter(View.class);
                    if (view == null) {
                        System.err.println("There are no View adapters in: " + nextViewAdapter);
                        continue;
                    }
                    EditPart nextEditPart = (EditPart)InteractionNestedLayoutEditPolicy.this.getHost().getViewer().getEditPartRegistry().get(view);
                    if (nextEditPart == null) {
                        System.err.println("There are no EditPart registered for view: " + view);
                        continue;
                    }
                    InteractionNestedLayoutEditPolicy.this.addToLayout(nextEditPart);
                }
                for (IGraphicalEditPart nextReshaped : request.getReshapedElements()) {
                    InteractionNestedLayoutEditPolicy.this.mySdLayout.elementReshaped(nextReshaped);
                }
                int i = 0;
                while (i < request.getSessionsCount()) {
                    InteractionNestedLayoutEditPolicy.this.mySdLayout.performLayout();
                    ++i;
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return new ICommandProxy((ICommand)result);
    }

    private InteractionEditPart getHostImpl() {
        return (InteractionEditPart)this.getHost();
    }

    private void addToLayout(EditPart editPart) {
        if (editPart instanceof ITextAwareEditPart) {
            return;
        }
        if (editPart instanceof ConnectionEditPart) {
            this.mySdLayout.linkAdded((ConnectionEditPart)editPart);
            return;
        }
        if (editPart instanceof GraphicalEditPart) {
            this.mySdLayout.nodeAdded((GraphicalEditPart)editPart);
        }
    }

    private void removeFromLayout(EditPart editPart) {
        if (editPart instanceof ITextAwareEditPart) {
            return;
        }
        if (editPart instanceof ConnectionEditPart) {
            this.mySdLayout.linkRemoved((ConnectionEditPart)editPart);
            return;
        }
        if (editPart instanceof GraphicalEditPart) {
            this.mySdLayout.nodeRemoved((GraphicalEditPart)editPart);
        }
    }

    private class EditPartTracker
    extends EditPartListener.Stub
    implements NodeListener {
        private EditPartTracker() {
        }

        public void childAdded(EditPart child, int index) {
            InteractionNestedLayoutEditPolicy.this.addToLayout(child);
            child.addEditPartListener((EditPartListener)this);
            if (child instanceof NodeEditPart) {
                ((NodeEditPart)child).addNodeListener((NodeListener)this);
                for (Object next : ((NodeEditPart)child).getSourceConnections()) {
                    org.eclipse.gef.ConnectionEditPart nextLink = (org.eclipse.gef.ConnectionEditPart)next;
                    InteractionNestedLayoutEditPolicy.this.addToLayout((EditPart)nextLink);
                }
            }
            InteractionNestedLayoutEditPolicy.this.setupNodesTree(child);
        }

        public void removingChild(EditPart child, int index) {
            child.removeEditPartListener((EditPartListener)this);
            if (child instanceof NodeEditPart) {
                ((NodeEditPart)child).removeNodeListener((NodeListener)this);
            }
            InteractionNestedLayoutEditPolicy.this.removeFromLayout(child);
        }

        public void removingSourceConnection(org.eclipse.gef.ConnectionEditPart connection, int index) {
            InteractionNestedLayoutEditPolicy.this.removeFromLayout((EditPart)connection);
        }

        public void removingTargetConnection(org.eclipse.gef.ConnectionEditPart connection, int index) {
        }

        public void sourceConnectionAdded(org.eclipse.gef.ConnectionEditPart connection, int index) {
            InteractionNestedLayoutEditPolicy.this.addToLayout((EditPart)connection);
        }

        public void targetConnectionAdded(org.eclipse.gef.ConnectionEditPart connection, int index) {
        }
    }
}

