/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.uml2.diagram.profile.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class ExtensionCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final Package container;

    public ExtensionCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = ExtensionCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Stereotype)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ElementImport)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canCreateExtension_4002(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        ElementImport elementImport = this.getTarget();
        Class metaclass = (Class)elementImport.getImportedElement();
        Stereotype stereotype = this.getSource();
        Extension newElement = stereotype.createExtension(metaclass, false);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(Extension newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Stereotype getSource() {
        return (Stereotype)this.source;
    }

    protected ElementImport getTarget() {
        return (ElementImport)this.target;
    }

    public Package getContainer() {
        return this.container;
    }

    private static Package deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Package) {
                return (Package)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

