/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMCallMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReturnMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;

class SendReceiveMessagesContainer {
    private final List myCallMessages = new ArrayList(1);
    private final List myReturnMessages = new ArrayList(1);

    SendReceiveMessagesContainer() {
    }

    void addMessage(LMMessage lmMessage) {
        if (lmMessage.isFromSendToReceive()) {
            this.myCallMessages.add(lmMessage);
        } else {
            this.myReturnMessages.add(lmMessage);
        }
    }

    void removeMessage(LMMessage lmMessage) {
        if (lmMessage.isFromSendToReceive()) {
            this.myCallMessages.remove(lmMessage);
        } else {
            this.myReturnMessages.remove(lmMessage);
        }
    }

    List getCallMessages() {
        return this.myCallMessages;
    }

    List getReturnMessages() {
        return this.myReturnMessages;
    }

    LMReturnMessage findReturnMessage(LMCallMessage lmCallMessage) {
        LMReceiveMessageEnd lmReceiveMessageEnd = lmCallMessage.getReceiveMessageEnd();
        if (lmReceiveMessageEnd == null) {
            return null;
        }
        for (LMReturnMessage lmReturnMessage : this.myReturnMessages) {
            if (lmReturnMessage.getReceiveMessageEnd() != lmReceiveMessageEnd) continue;
            return lmReturnMessage;
        }
        return null;
    }

    Collection getOutgoingLMMessages(LMSendMessageEnd sendMessageEnd) {
        LMMessage lmMessage1;
        ArrayList<LMMessage> result = new ArrayList<LMMessage>(1);
        int i = 0;
        while (i < this.getCallMessages().size()) {
            lmMessage1 = (LMMessage)this.getCallMessages().get(i);
            if (lmMessage1.getSendMessageEnd() == sendMessageEnd) {
                result.add(lmMessage1);
            }
            ++i;
        }
        i = 0;
        while (i < this.getReturnMessages().size()) {
            lmMessage1 = (LMMessage)this.getReturnMessages().get(i);
            if (lmMessage1.getSendMessageEnd() == sendMessageEnd) {
                result.add(lmMessage1);
            }
            ++i;
        }
        return result;
    }
}

