/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementChooserPage;
import org.eclipse.uml2.diagram.common.sheet.chooser.TabbedElementChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceElementChooserDialog
extends TrayDialog {
    protected EList<Object> result;
    protected ItemProvider values;
    private AdapterFactoryLabelProvider labelProvider;
    private final AdapterFactory myItemProvidersAdapterFactory;
    private final EObject mySourceObject;
    private final EStructuralFeature myFeature;
    private final TabbedElementChooser myChooser;
    private final TransactionalEditingDomain myEditingDomain;

    public MultiReferenceElementChooserDialog(Shell parent, IDialogSettings settings, AdapterFactory itemProvidersAdapterFactory, EObject sourceObject, EStructuralFeature feature) {
        super(parent);
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
        this.mySourceObject = sourceObject;
        this.myFeature = feature;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        List currentValues = (List)sourceObject.eGet(feature);
        this.values = new ItemProvider(itemProvidersAdapterFactory, (Collection)currentValues);
        this.labelProvider = new AdapterFactoryLabelProvider(this.myItemProvidersAdapterFactory);
        this.myEditingDomain = TransactionUtil.getEditingDomain((EObject)sourceObject);
        this.myChooser = new TabbedElementChooser(settings, itemProvidersAdapterFactory, sourceObject, feature, this.myEditingDomain);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.MultiReferenceElementChooserDialog_dialod_choose_element, (Object[])new Object[]{this.myFeature.getName(), this.labelProvider.getText((Object)this.mySourceObject)}));
        shell.setImage(this.labelProvider.getImage((Object)this.mySourceObject));
    }

    public void create() {
        super.create();
        this.myChooser.initSelection();
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(NLS.bind((String)Messages.MultiReferenceElementChooserDialog_label_choose_element, (Object[])new Object[]{this.myFeature.getEType().getName()}));
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        Control choiceTable = this.myChooser.createDialogArea(choiceComposite);
        GridData choiceTableGridData = new GridData();
        choiceTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        choiceTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        choiceTableGridData.verticalAlignment = 4;
        choiceTableGridData.horizontalAlignment = 4;
        choiceTableGridData.grabExcessHorizontalSpace = true;
        choiceTableGridData.grabExcessVerticalSpace = true;
        choiceTable.setLayoutData((Object)choiceTableGridData);
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        final Button addButton = new Button(controlButtons, 8);
        addButton.setText(Messages.MultiReferenceElementChooserDialog_button_add);
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        final Button removeButton = new Button(controlButtons, 8);
        removeButton.setText(Messages.MultiReferenceElementChooserDialog_button_remove);
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Button upButton = new Button(controlButtons, 8);
        upButton.setText(Messages.MultiReferenceElementChooserDialog_button_up);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        upButton.setLayoutData((Object)upButtonGridData);
        Button downButton = new Button(controlButtons, 8);
        downButton.setText(Messages.MultiReferenceElementChooserDialog_button_down);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        downButton.setLayoutData((Object)downButtonGridData);
        Composite featureComposite = new Composite(contents, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        featureComposite.setLayout((Layout)layout2);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(Messages.MultiReferenceElementChooserDialog_label_selected_elements);
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        Table featureTable = new Table(featureComposite, 2050);
        GridData featureTableGridData = new GridData();
        featureTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        featureTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        featureTableGridData.verticalAlignment = 4;
        featureTableGridData.horizontalAlignment = 4;
        featureTableGridData.grabExcessHorizontalSpace = true;
        featureTableGridData.grabExcessVerticalSpace = true;
        featureTable.setLayoutData((Object)featureTableGridData);
        final TableViewer featureTableViewer = new TableViewer(featureTable);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.myItemProvidersAdapterFactory);
        featureTableViewer.setContentProvider((IContentProvider)contentProvider);
        featureTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        featureTableViewer.setInput((Object)this.values);
        if (!this.values.getChildren().isEmpty()) {
            featureTableViewer.setSelection((ISelection)new StructuredSelection(this.values.getChildren().get(0)));
        }
        if (this.myChooser != null) {
            this.myChooser.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (addButton.isEnabled()) {
                        addButton.notifyListeners(13, null);
                    }
                }
            });
            featureTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (removeButton.isEnabled()) {
                        removeButton.notifyListeners(13, null);
                    }
                }
            });
        }
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int minIndex = 0;
                for (Object value : selection) {
                    int index = MultiReferenceElementChooserDialog.this.values.getChildren().indexOf(value);
                    MultiReferenceElementChooserDialog.this.values.getChildren().move(Math.max(index - 1, minIndex++), value);
                }
            }
        });
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int maxIndex = MultiReferenceElementChooserDialog.this.values.getChildren().size() - selection.size();
                for (Object value : selection) {
                    int index = MultiReferenceElementChooserDialog.this.values.getChildren().indexOf(value);
                    MultiReferenceElementChooserDialog.this.values.getChildren().move(Math.min(index + 1, maxIndex++), value);
                }
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MultiReferenceElementChooserDialog.this.myChooser != null) {
                    List<?> selection = MultiReferenceElementChooserDialog.this.myChooser.getSelection();
                    for (Object value : selection) {
                        if (MultiReferenceElementChooserDialog.this.values.getChildren().contains(value)) continue;
                        MultiReferenceElementChooserDialog.this.values.getChildren().add(value);
                    }
                    featureTableViewer.setSelection((ISelection)new StructuredSelection(selection));
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    MultiReferenceElementChooserDialog.this.values.getChildren().remove(value);
                }
                if (!MultiReferenceElementChooserDialog.this.values.getChildren().isEmpty()) {
                    featureTableViewer.setSelection((ISelection)new StructuredSelection(MultiReferenceElementChooserDialog.this.values.getChildren().get(0)));
                }
                if (MultiReferenceElementChooserDialog.this.myChooser != null) {
                    MultiReferenceElementChooserDialog.this.myChooser.setSelection(selection.toList());
                }
            }
        });
        final ElementChooserPage.Validator validator = this.myChooser.getValidator();
        this.myChooser.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isEnabled = true;
                for (Object firstSelected : MultiReferenceElementChooserDialog.this.myChooser.getSelection()) {
                    isEnabled &= validator.validate(firstSelected) != null;
                }
                addButton.setEnabled(isEnabled);
            }
        });
        return contents;
    }

    protected void okPressed() {
        this.result = new BasicEList();
        for (Object next : this.values.getChildren()) {
            URI uri = EcoreUtil.getURI((EObject)((EObject)next));
            this.result.add((Object)this.myEditingDomain.getResourceSet().getEObject(uri, true));
        }
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    public EList<Object> getResult() {
        return this.result;
    }
}

