package org.eclipse.uml2.diagram.component.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.diagram.component.edit.parts.Class2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ClassDiagramNotationClassEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ClassEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.Component2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.Component3EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentContents2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentContentsEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.Interface2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.InterfaceEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.Package2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.Package3EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.PackageEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.PortEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.PortOnClassEditPart;
import org.eclipse.uml2.diagram.component.part.Messages;
import org.eclipse.uml2.diagram.component.part.UMLDiagramEditorPlugin;

/**
 * @generated
 */
public class UMLModelingAssistantProvider extends ModelingAssistantProvider {

	/**
	 * @generated
	 */
	public List<?> getTypesForPopupBar(IAdaptable host) {
		IGraphicalEditPart editPart = (IGraphicalEditPart) host.getAdapter(IGraphicalEditPart.class);

		if (editPart instanceof ComponentEditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Port_3002);
			return types;
		}

		if (editPart instanceof Class2EditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Port_3002);
			return types;
		}

		if (editPart instanceof Package2EditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.ElementImport_3007);
			return types;
		}

		if (editPart instanceof Package3EditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Package_3008);
			types.add(UMLElementTypes.Class_3009);
			types.add(UMLElementTypes.Component_3010);
			return types;
		}

		if (editPart instanceof ClassDiagramNotationClassEditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Port_3014);
			types.add(UMLElementTypes.Property_3011);
			types.add(UMLElementTypes.Operation_3012);
			types.add(UMLElementTypes.Class_3013);
			return types;
		}

		if (editPart instanceof Component2EditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Port_3002);
			return types;
		}

		if (editPart instanceof ClassEditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Port_3002);
			return types;
		}

		if (editPart instanceof ComponentContentsEditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Component_3001);
			types.add(UMLElementTypes.Artifact_3003);
			types.add(UMLElementTypes.Class_3004);
			types.add(UMLElementTypes.Interface_3005);
			types.add(UMLElementTypes.Property_3006);
			types.add(UMLElementTypes.Connector_3015);
			return types;
		}

		if (editPart instanceof ComponentContents2EditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Component_3001);
			types.add(UMLElementTypes.Artifact_3003);
			types.add(UMLElementTypes.Class_3004);
			types.add(UMLElementTypes.Interface_3005);
			types.add(UMLElementTypes.Property_3006);
			types.add(UMLElementTypes.Connector_3015);
			return types;
		}

		if (editPart instanceof PackageEditPart) {
			List<IElementType> types = new ArrayList<IElementType>();
			types.add(UMLElementTypes.Component_2001);
			types.add(UMLElementTypes.Artifact_2002);
			types.add(UMLElementTypes.Interface_2003);
			types.add(UMLElementTypes.Class_2004);
			types.add(UMLElementTypes.Package_2006);
			types.add(UMLElementTypes.Class_2007);
			return types;
		}
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSource(IAdaptable source) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof ComponentEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.ComponentRequired_4007);
			return types;
		}
		if (sourceEditPart instanceof Component2EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.ComponentRequired_4007);
			return types;
		}
		if (sourceEditPart instanceof PortEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.PortProvided_4006);
			types.add(UMLElementTypes.PortRequired_4004);
			return types;
		}
		if (sourceEditPart instanceof Component3EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.ComponentRequired_4007);
			return types;
		}
		if (sourceEditPart instanceof PortOnClassEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.PortProvided_4006);
			types.add(UMLElementTypes.PortRequired_4004);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnTarget(IAdaptable target) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof Interface2EditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.InterfaceRealization_4001);
			types.add(UMLElementTypes.PortProvided_4006);
			types.add(UMLElementTypes.PortRequired_4004);
			types.add(UMLElementTypes.ComponentRequired_4007);
			return types;
		}
		if (targetEditPart instanceof InterfaceEditPart) {
			List types = new ArrayList();
			types.add(UMLElementTypes.InterfaceRealization_4001);
			types.add(UMLElementTypes.PortProvided_4006);
			types.add(UMLElementTypes.PortRequired_4004);
			types.add(UMLElementTypes.ComponentRequired_4007);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof ComponentEditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			return types;
		}
		if (sourceEditPart instanceof Component2EditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			return types;
		}
		if (sourceEditPart instanceof PortEditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.PortProvided_4006);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.PortProvided_4006);
			}
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.PortRequired_4004);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.PortRequired_4004);
			}
			return types;
		}
		if (sourceEditPart instanceof Component3EditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.ComponentRequired_4007);
			}
			return types;
		}
		if (sourceEditPart instanceof PortOnClassEditPart) {
			List types = new ArrayList();
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.PortProvided_4006);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.PortProvided_4006);
			}
			if (targetEditPart instanceof Interface2EditPart) {
				types.add(UMLElementTypes.PortRequired_4004);
			}
			if (targetEditPart instanceof InterfaceEditPart) {
				types.add(UMLElementTypes.PortRequired_4004);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForSource(IAdaptable target, IElementType relationshipType) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof Interface2EditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Port_3002);
			}
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Port_3014);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Port_3002);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Port_3014);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_2001);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_3001);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_3010);
			}
			return types;
		}
		if (targetEditPart instanceof InterfaceEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Port_3002);
			}
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Port_3014);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Port_3002);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Port_3014);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_2001);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_3001);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Component_3010);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForTarget(IAdaptable source, IElementType relationshipType) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof ComponentEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_3005);
			}
			return types;
		}
		if (sourceEditPart instanceof Component2EditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_3005);
			}
			return types;
		}
		if (sourceEditPart instanceof PortEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Interface_3005);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Interface_3005);
			}
			return types;
		}
		if (sourceEditPart instanceof Component3EditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.ComponentRequired_4007) {
				types.add(UMLElementTypes.Interface_3005);
			}
			return types;
		}
		if (sourceEditPart instanceof PortOnClassEditPart) {
			List types = new ArrayList();
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.PortProvided_4006) {
				types.add(UMLElementTypes.Interface_3005);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Interface_2003);
			}
			if (relationshipType == UMLElementTypes.PortRequired_4004) {
				types.add(UMLElementTypes.Interface_3005);
			}
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
		return selectExistingElement(target, getTypesForSource(target, relationshipType));
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
		return selectExistingElement(source, getTypesForTarget(source, relationshipType));
	}

	/**
	 * @generated
	 */
	protected EObject selectExistingElement(IAdaptable host, Collection types) {
		if (types.isEmpty()) {
			return null;
		}
		IGraphicalEditPart editPart = (IGraphicalEditPart) host.getAdapter(IGraphicalEditPart.class);
		if (editPart == null) {
			return null;
		}
		Diagram diagram = (Diagram) editPart.getRoot().getContents().getModel();
		Collection elements = new HashSet();
		for (Iterator it = diagram.getElement().eAllContents(); it.hasNext();) {
			EObject element = (EObject) it.next();
			if (isApplicableElement(element, types)) {
				elements.add(element);
			}
		}
		if (elements.isEmpty()) {
			return null;
		}
		return selectElement((EObject[]) elements.toArray(new EObject[elements.size()]));
	}

	/**
	 * @generated
	 */
	protected boolean isApplicableElement(EObject element, Collection types) {
		IElementType type = ElementTypeRegistry.getInstance().getElementType(element);
		return types.contains(type);
	}

	/**
	 * @generated
	 */
	protected EObject selectElement(EObject[] elements) {
		Shell shell = Display.getCurrent().getActiveShell();
		ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, labelProvider);
		dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
		dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
		dialog.setMultipleSelection(false);
		dialog.setElements(elements);
		EObject selected = null;
		if (dialog.open() == Window.OK) {
			selected = (EObject) dialog.getFirstResult();
		}
		return selected;
	}
}
