/**
 * <copyright>
 * </copyright>
 *
 * $Id: GMFGenExtItemProviderAdapterFactory.java,v 1.6 2008/05/07 17:42:49 mgolubev Exp $
 */
package org.eclipse.uml2.diagram.codegen.gmfgenext.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.edit.command.CommandParameter;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;

import org.eclipse.gmf.codegen.gmfgen.util.GMFGenSwitch;

import org.eclipse.uml2.diagram.codegen.gmfgenext.GMFGenExtFactory;

import org.eclipse.uml2.diagram.codegen.gmfgenext.util.GMFGenExtAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GMFGenExtItemProviderAdapterFactory extends GMFGenExtAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GMFGenExtItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.AuxSecondaryDiagramNodeAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AuxSecondaryDiagramNodeAttributeItemProvider auxSecondaryDiagramNodeAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.AuxSecondaryDiagramNodeAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createAuxSecondaryDiagramNodeAttributeAdapter() {
		if (auxSecondaryDiagramNodeAttributeItemProvider == null) {
			auxSecondaryDiagramNodeAttributeItemProvider = new AuxSecondaryDiagramNodeAttributeItemProvider(this);
		}

		return auxSecondaryDiagramNodeAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.CustomLocatorAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomLocatorAttributesItemProvider customLocatorAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.CustomLocatorAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCustomLocatorAttributesAdapter() {
		if (customLocatorAttributesItemProvider == null) {
			customLocatorAttributesItemProvider = new CustomLocatorAttributesItemProvider(this);
		}

		return customLocatorAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.DetailsLevelAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DetailsLevelAttributesItemProvider detailsLevelAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.DetailsLevelAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDetailsLevelAttributesAdapter() {
		if (detailsLevelAttributesItemProvider == null) {
			detailsLevelAttributesItemProvider = new DetailsLevelAttributesItemProvider(this);
		}

		return detailsLevelAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.SubstitutableByAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubstitutableByAttributesItemProvider substitutableByAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.SubstitutableByAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSubstitutableByAttributesAdapter() {
		if (substitutableByAttributesItemProvider == null) {
			substitutableByAttributesItemProvider = new SubstitutableByAttributesItemProvider(this);
		}

		return substitutableByAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.DynamicCanonicalCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DynamicCanonicalCompartmentItemProvider dynamicCanonicalCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.DynamicCanonicalCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDynamicCanonicalCompartmentAdapter() {
		if (dynamicCanonicalCompartmentItemProvider == null) {
			dynamicCanonicalCompartmentItemProvider = new DynamicCanonicalCompartmentItemProvider(this);
		}

		return dynamicCanonicalCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.uml2.diagram.codegen.gmfgenext.InteractionDiagramAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InteractionDiagramAttributesItemProvider interactionDiagramAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.uml2.diagram.codegen.gmfgenext.InteractionDiagramAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createInteractionDiagramAttributesAdapter() {
		if (interactionDiagramAttributesItemProvider == null) {
			interactionDiagramAttributesItemProvider = new InteractionDiagramAttributesItemProvider(this);
		}

		return interactionDiagramAttributesItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (auxSecondaryDiagramNodeAttributeItemProvider != null) auxSecondaryDiagramNodeAttributeItemProvider.dispose();
		if (customLocatorAttributesItemProvider != null) customLocatorAttributesItemProvider.dispose();
		if (detailsLevelAttributesItemProvider != null) detailsLevelAttributesItemProvider.dispose();
		if (substitutableByAttributesItemProvider != null) substitutableByAttributesItemProvider.dispose();
		if (dynamicCanonicalCompartmentItemProvider != null) dynamicCanonicalCompartmentItemProvider.dispose();
		if (interactionDiagramAttributesItemProvider != null) interactionDiagramAttributesItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link GMFGenPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class GMFGenChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends GMFGenSwitch {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			public Object caseViewmap(Viewmap object) {
				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createAuxSecondaryDiagramNodeAttribute()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createCustomLocatorAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createDetailsLevelAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createSubstitutableByAttributes()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createDynamicCanonicalCompartment()));

				newChildDescriptors.add
					(createChildParameter
						(GMFGenPackage.eINSTANCE.getViewmap_Attributes(),
						 GMFGenExtFactory.eINSTANCE.createInteractionDiagramAttributes()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList result = new ArrayList();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return GMFGenExtEditPlugin.INSTANCE;
		}
	}

}
