/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedElementOperations
extends ElementOperations {
    protected static final String LABEL_KEY_PREFIX = "_label_";

    protected NamedElementOperations() {
    }

    public static boolean validateHasNoQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateHasQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateVisibilityNeedsOwnership(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (namedElement.getNamespace() == null && namedElement.eIsSet((EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 16, UMLPlugin.INSTANCE.getString("_UI_NamedElement_VisibilityNeedsOwnership_diagnostic", NamedElementOperations.getMessageSubstitutions(context, (Object)namedElement)), new Object[]{namedElement}));
            }
        }
        return result;
    }

    protected static Dependency createDependency(NamedElement namedElement, NamedElement supplier, EClass eClass) {
        Package package_ = namedElement.getNearestPackage();
        if (package_ == null) {
            throw new IllegalStateException();
        }
        if (supplier == null) {
            throw new IllegalArgumentException(String.valueOf(supplier));
        }
        Dependency dependency = (Dependency)package_.createPackagedElement(null, eClass);
        dependency.getClients().add((Object)namedElement);
        dependency.getSuppliers().add((Object)supplier);
        return dependency;
    }

    public static Dependency createDependency(NamedElement namedElement, NamedElement supplier) {
        return NamedElementOperations.createDependency(namedElement, supplier, UMLPackage.Literals.DEPENDENCY);
    }

    public static String getLabel(NamedElement namedElement) {
        return namedElement.getLabel(true);
    }

    public static String getLabel(NamedElement namedElement, boolean localize) {
        String qualifiedName = namedElement.getQualifiedName();
        return NamedElementOperations.getString((EObject)namedElement, (String)(LABEL_KEY_PREFIX + NamedElementOperations.getValidJavaIdentifier((String)(NamedElementOperations.isEmpty((String)qualifiedName) ? "" : qualifiedName.replace(':', '_')))), (String)namedElement.getName(), (boolean)localize);
    }

    public static Usage createUsage(NamedElement namedElement, NamedElement supplier) {
        return (Usage)NamedElementOperations.createDependency(namedElement, supplier, UMLPackage.Literals.USAGE);
    }

    public static String getQualifiedName(NamedElement namedElement) {
        return NamedElementOperations.getQualifiedName(namedElement, namedElement.separator());
    }

    protected static EList<Namespace> allNamespaces(NamedElement namedElement, EList<Namespace> allNamespaces) {
        Namespace namespace = namedElement.getNamespace();
        if (namespace != null && allNamespaces.add((Object)namespace)) {
            NamedElementOperations.allNamespaces(namespace, allNamespaces);
        }
        return allNamespaces;
    }

    public static EList<Namespace> allNamespaces(NamedElement namedElement) {
        return ECollections.unmodifiableEList(NamedElementOperations.allNamespaces(namedElement, (EList<Namespace>)new UniqueEList.FastCompare()));
    }

    public static boolean isDistinguishableFrom(NamedElement namedElement, NamedElement n, Namespace ns) {
        EClass eClass = namedElement.eClass();
        EClass nEClass = n.eClass();
        if (nEClass.isSuperTypeOf(eClass) || eClass.isSuperTypeOf(nEClass)) {
            EList<String> namesOfN = ns.getNamesOfMember(n);
            for (String nameOfNamedElement : ns.getNamesOfMember(namedElement)) {
                if (!namesOfN.contains((Object)nameOfNamedElement)) continue;
                return false;
            }
        }
        return true;
    }

    public static Namespace getNamespace(NamedElement namedElement) {
        Namespace namespace;
        InternalEObject eInternalContainer = ((InternalEObject)namedElement).eInternalContainer();
        if (eInternalContainer instanceof Namespace && (namespace = (Namespace)eInternalContainer).getMembers().contains((Object)namedElement)) {
            return namespace;
        }
        return null;
    }

    public static String separator(NamedElement namedElement) {
        return "::";
    }

    public static EList<Package> allOwningPackages(NamedElement namedElement) {
        UniqueEList.FastCompare allOwningPackages = new UniqueEList.FastCompare();
        while ((namedElement = (NamedElement)NamedElementOperations.getOwningElement(namedElement, UMLPackage.Literals.PACKAGE, true)) != null) {
            allOwningPackages.add((Object)((Package)namedElement));
        }
        return ECollections.unmodifiableEList((EList)allOwningPackages);
    }
}

