/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InteractionOperatorKind implements Enumerator
{
    SEQ_LITERAL(0, "seq", "seq"),
    ALT_LITERAL(1, "alt", "alt"),
    OPT_LITERAL(2, "opt", "opt"),
    BREAK_LITERAL(3, "break", "break"),
    PAR_LITERAL(4, "par", "par"),
    STRICT_LITERAL(5, "strict", "strict"),
    LOOP_LITERAL(6, "loop", "loop"),
    CRITICAL_LITERAL(7, "critical", "critical"),
    NEG_LITERAL(8, "neg", "neg"),
    ASSERT_LITERAL(9, "assert", "assert"),
    IGNORE_LITERAL(10, "ignore", "ignore"),
    CONSIDER_LITERAL(11, "consider", "consider");

    public static final int SEQ = 0;
    public static final int ALT = 1;
    public static final int OPT = 2;
    public static final int BREAK = 3;
    public static final int PAR = 4;
    public static final int STRICT = 5;
    public static final int LOOP = 6;
    public static final int CRITICAL = 7;
    public static final int NEG = 8;
    public static final int ASSERT = 9;
    public static final int IGNORE = 10;
    public static final int CONSIDER = 11;
    private static final InteractionOperatorKind[] VALUES_ARRAY;
    public static final List<InteractionOperatorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InteractionOperatorKind[]{SEQ_LITERAL, ALT_LITERAL, OPT_LITERAL, BREAK_LITERAL, PAR_LITERAL, STRICT_LITERAL, LOOP_LITERAL, CRITICAL_LITERAL, NEG_LITERAL, ASSERT_LITERAL, IGNORE_LITERAL, CONSIDER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InteractionOperatorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionOperatorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionOperatorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionOperatorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionOperatorKind get(int value) {
        switch (value) {
            case 0: {
                return SEQ_LITERAL;
            }
            case 1: {
                return ALT_LITERAL;
            }
            case 2: {
                return OPT_LITERAL;
            }
            case 3: {
                return BREAK_LITERAL;
            }
            case 4: {
                return PAR_LITERAL;
            }
            case 5: {
                return STRICT_LITERAL;
            }
            case 6: {
                return LOOP_LITERAL;
            }
            case 7: {
                return CRITICAL_LITERAL;
            }
            case 8: {
                return NEG_LITERAL;
            }
            case 9: {
                return ASSERT_LITERAL;
            }
            case 10: {
                return IGNORE_LITERAL;
            }
            case 11: {
                return CONSIDER_LITERAL;
            }
        }
        return null;
    }

    private InteractionOperatorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

