/**
 * Copyright (c) 2007, 2014 Borland Software Corporation, CEA, and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - refactored javaInitilizers not to use methods from GMFGen model
 *                               [221347] Got rid of generated interfaces
 *                               (IObjectInitializer, IFeatureInitializer) and implementation thereof
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Christian W. Damus (CEA) - bug 440263
 */
package aspects.xpt.providers;

import aspects.xpt.Common;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
@SuppressWarnings("all")
public class ParserUtils_qvto extends xpt.providers.ParserUtils_qvto {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public String parserFieldName(final GenCommonBase element) {
    String _firstLower = StringExtensions.toFirstLower(this._common.stringUniqueIdentifier(element));
    return (_firstLower + "_Parser");
  }
  
  @Override
  public String parserAccessorName(final GenCommonBase element) {
    String _firstUpper = StringExtensions.toFirstUpper(this._common.stringUniqueIdentifier(element));
    String _plus = ("get" + _firstUpper);
    return (_plus + "_Parser");
  }
}
