/**
 * Copyright (c) 2006, 2009, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.diagram.editparts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.CustomBehaviour;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.papyrusgmfgenextension.LabelVisibilityPreference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class LinkLabelEditPart extends diagram.editparts.LinkLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence implementsList(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart, org.eclipse.papyrus.infra.gmfdiag.common.editpart.IControlParserForDirectEdit");
    _builder.newLine();
    {
      final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
        @Override
        public Boolean apply(final LabelVisibilityPreference v) {
          return Boolean.valueOf(v.getLinkLabels().contains(it));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        _builder.append(", org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence additions(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
        @Override
        public Boolean apply(final LabelVisibilityPreference v) {
          return Boolean.valueOf(v.getLinkLabels().contains(it));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append(_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getLabelRole(){");
        _builder.newLine();
        _builder.append("return \"");
        final Function1<LabelVisibilityPreference, Boolean> _function_1 = new Function1<LabelVisibilityPreference, Boolean>() {
          @Override
          public Boolean apply(final LabelVisibilityPreference v) {
            return Boolean.valueOf(v.getLinkLabels().contains(it));
          }
        };
        String _role = IteratorExtensions.<LabelVisibilityPreference>head(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function_1)).getRole();
        _builder.append(_role);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append(_generatedClassComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getIconPathRole(){");
        _builder.newLine();
        _builder.append("return \"");
        final Function1<LabelVisibilityPreference, Boolean> _function_2 = new Function1<LabelVisibilityPreference, Boolean>() {
          @Override
          public Boolean apply(final LabelVisibilityPreference v) {
            return Boolean.valueOf(v.getLinkLabels().contains(it));
          }
        };
        String _iconPathRole = IteratorExtensions.<LabelVisibilityPreference>head(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function_2)).getIconPathRole();
        _builder.append(_iconPathRole);
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence extendsList(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart");
    return _builder;
  }
  
  @Override
  public CharSequence createDefaultEditPolicies(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated Papyrus Generation");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected void createDefaultEditPolicies() {\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new ");
    String _textSelectionEditPolicyQualifiedClassName = it.getDiagram().getTextSelectionEditPolicyQualifiedClassName();
    _builder.append(_textSelectionEditPolicyQualifiedClassName, "\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusLinkLabelDragPolicy());");
    _builder.newLine();
    {
      Iterable<CustomBehaviour> _filter = Iterables.<CustomBehaviour>filter(it.getBehaviour(), CustomBehaviour.class);
      for(final CustomBehaviour CustomBehaviour : _filter) {
        _builder.append("installEditPolicy(");
        String _key = CustomBehaviour.getKey();
        _builder.append(_key);
        _builder.append(", new ");
        String _editPolicyQualifiedClassName = CustomBehaviour.getEditPolicyQualifiedClassName();
        _builder.append(_editPolicyQualifiedClassName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
