/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.intermediateactions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.AbstractActionPinUpdater;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;

public class AcceptCallActionPinUpdater
extends AbstractActionPinUpdater<AcceptCallAction> {
    @Override
    public void updatePins(AcceptCallAction node) {
        if (node != null) {
            Trigger trigger;
            Event event;
            EList originPins = node.getResults();
            ArrayList<OutputPin> keepOutputPins = new ArrayList<OutputPin>();
            OutputPin returnInformation = node.getReturnInformation();
            if (returnInformation == null) {
                returnInformation = UMLFactory.eINSTANCE.createOutputPin();
                returnInformation.setName("return information");
                node.setReturnInformation(returnInformation);
                node.setIsUnmarshall(true);
            }
            if (node.getTriggers().size() == 1 && (event = (trigger = (Trigger)node.getTriggers().get(0)).getEvent()) instanceof CallEvent) {
                for (Parameter parameter : ((CallEvent)event).getOperation().getOwnedParameters()) {
                    if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                    OutputPin outputPin = node.getResult(parameter.getName(), parameter.getType(), true, true);
                    if (parameter.getType() == null) {
                        outputPin.setType(null);
                    }
                    outputPin.setType(parameter.getType());
                    outputPin.setLower(parameter.getLower());
                    outputPin.setUpper(parameter.getUpper());
                    outputPin.setName(parameter.getName());
                    keepOutputPins.add(outputPin);
                }
            }
            for (OutputPin pin : originPins) {
                if (keepOutputPins.contains(pin)) continue;
                AcceptCallActionPinUpdater.deleteEdges((Pin)pin);
            }
            originPins.clear();
            originPins.addAll(keepOutputPins);
        }
    }
}

