/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateMachineResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateMachineSetBoundsCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPartTN;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineEditPart;

public class CustomPackageXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (request == null || child == null || constraint == null) {
            throw new IllegalArgumentException();
        }
        if (child instanceof StateMachineEditPart || child instanceof StateEditPartTN) {
            View stateMachine = (View)child.getModel();
            int dx = request.getSizeDelta().width;
            int dy = request.getSizeDelta().height;
            if (dx == 0 && dy == 0) {
                return super.createChangeConstraintCommand(request, child, constraint);
            }
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            SemanticAdapter adaptableForStateMachine = new SemanticAdapter(null, (Object)stateMachine);
            CustomStateMachineResizeCommand resizeStateMachine = new CustomStateMachineResizeCommand((IAdaptable)adaptableForStateMachine, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, request, (Rectangle)constraint, false);
            cc.add((IUndoableOperation)resizeStateMachine);
            return new ICommandProxy(cc.reduce());
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof StateMachineEditPart || child instanceof StateEditPartTN) {
            ResizableEditPolicy policy = new ResizableEditPolicy(){

                public void eraseSourceFeedback(Request request) {
                    if ("drop".equals(request.getType())) {
                        this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
                    } else {
                        super.eraseSourceFeedback(request);
                    }
                }
            };
            return policy;
        }
        return super.createChildEditPolicy(child);
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        while (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            cc.compose((IUndoableOperation)new CustomStateMachineSetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, viewDescriptor, rect));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }
}

