/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.AssociationClassHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ClassLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ContainmentHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.InstanceSpecificationLinkHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.MultiAssociationHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.MultiDependencyHelper;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.RedefinableTemplateSignatureEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.strategy.paste.ShowConstraintContextLink;
import org.eclipse.papyrus.uml.diagram.common.util.AssociationUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;

public class ClassDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public static final String CONTAINED_CLASS_DROP_TO_COMPARTMENT = "ContainedClassDropToCompartment";

    public ClassDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ClassLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualID = new HashSet<String>();
        droppableElementsVisualID.add("Dependency_Shape");
        droppableElementsVisualID.add("Association_Edge");
        droppableElementsVisualID.add("AssociationClass_Shape");
        droppableElementsVisualID.add("Association_Shape");
        droppableElementsVisualID.add("Class_ClassNestedClassifierLabel");
        droppableElementsVisualID.add("Class_Shape_CN");
        droppableElementsVisualID.add("Package_Shape_CN");
        droppableElementsVisualID.add("Model_Shape_CN");
        droppableElementsVisualID.add("Model_Shape");
        droppableElementsVisualID.add("Class_Shape");
        droppableElementsVisualID.add("Package_Shape");
        droppableElementsVisualID.add("InstanceSpecification_Shape");
        droppableElementsVisualID.add("InstanceSpecification_Edge");
        droppableElementsVisualID.add("Constraint_PackagedElementShape");
        return droppableElementsVisualID;
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID, String linkVISUALID) {
        block38: {
            if ("EnumerationLiteral_LiteralLabel".equals(nodeVISUALID)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticLink));
            }
            if ("InstanceSpecification_Shape".equals(nodeVISUALID) || "InstanceSpecification_Edge".equals(linkVISUALID)) {
                return this.dropInstanceSpecification(dropRequest, semanticLink, linkVISUALID);
            }
            if ("Substitution_Edge".equals(linkVISUALID)) {
                return this.dropAsNormalBinaryLink(dropRequest, semanticLink, linkVISUALID);
            }
            if ("InterfaceRealization_Edge".equals(linkVISUALID)) {
                return this.dropAsNormalBinaryLink(dropRequest, semanticLink, linkVISUALID);
            }
            if ("Association_Edge".equals(linkVISUALID)) {
                return this.dropAssociation(dropRequest, semanticLink);
            }
            if ("Usage_Edge".equals(linkVISUALID)) {
                return this.dropAsNormalBinaryLink(dropRequest, semanticLink, linkVISUALID);
            }
            if (nodeVISUALID == null) break block38;
            switch (nodeVISUALID) {
                case "Dependency_Shape": {
                    return this.dropDependency(dropRequest, semanticLink);
                }
                case "AssociationClass_Shape": {
                    return this.dropAssociationClass(dropRequest, semanticLink, nodeVISUALID);
                }
                case "Association_Shape": {
                    return this.dropAssociation(dropRequest, semanticLink);
                }
                case "Package_Shape_CN": 
                case "Class_ClassNestedClassifierLabel": 
                case "Model_Shape_CN": 
                case "Class_Shape_CN": {
                    return this.dropChildNodeWithContainmentLink(dropRequest, semanticLink, nodeVISUALID);
                }
                case "Model_Shape": 
                case "Package_Shape": 
                case "Class_Shape": {
                    return this.dropTopLevelNodeWithContainmentLink(dropRequest, semanticLink, nodeVISUALID);
                }
                case "Constraint_PackagedElementShape": {
                    return this.dropConstraintNode(dropRequest, (Constraint)semanticLink, nodeVISUALID);
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropInstanceSpecification(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        if (!(semanticLink instanceof InstanceSpecification)) {
            return UnexecutableCommand.INSTANCE;
        }
        List<InstanceSpecification> endTypes = InstanceSpecificationLinkHelper.getEnds((InstanceSpecification)semanticLink);
        if (endTypes.size() > 0) {
            Element source = (Element)endTypes.get(0);
            Element target = (Element)endTypes.get(1);
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Instance"), source, target, "InstanceSpecification_Edge", dropRequest.getLocation(), semanticLink));
        }
        EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (this.getHost().getModel() instanceof Diagram) {
            return new ICommandProxy(this.getDefaultDropNodeCommand("InstanceSpecification_Shape", dropRequest.getLocation(), (EObject)semanticLink));
        }
        if (graphicalParent instanceof Element && ((Element)graphicalParent).getOwnedElements().contains((Object)semanticLink)) {
            return new ICommandProxy(this.getDefaultDropNodeCommand("InstanceSpecification_Shape_CN", dropRequest.getLocation(), (EObject)semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    protected Command dropAssociation(DropObjectsRequest dropRequest, Element semanticLink) {
        ArrayList endtypes = new ArrayList(ClassLinkMappingHelper.getInstance().getSource(semanticLink));
        if (endtypes.size() == 1) {
            Element source = (Element)endtypes.get(0);
            Element target = (Element)endtypes.get(0);
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), source, target, "Association_Edge", dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() == 2) {
            Type source = AssociationUtil.getInitialSourceSecondEnd((Association)((Association)semanticLink)).getType();
            Type target = AssociationUtil.getInitialTargetFirstEnd((Association)((Association)semanticLink)).getType();
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Association"), (Element)source, (Element)target, "Association_Edge", dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() > 2) {
            MultiAssociationHelper associationHelper = new MultiAssociationHelper(this.getEditingDomain());
            return associationHelper.dropMutliAssociation((Association)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAssociationClass(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        AssociationClassHelper associationClassHelper = new AssociationClassHelper(this.getEditingDomain());
        return associationClassHelper.dropAssociationClass((AssociationClass)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink) {
        Collection<?> sources = ClassLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ClassLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Dependency"), source, target, "Dependency_Edge", dropRequest.getLocation(), semanticLink));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain(), this.getElement2IAdaptableRegistryHelper());
            return dependencyHelper.dropMutliDependency((Dependency)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTopLevelNodeWithContainmentLink(DropObjectsRequest dropRequest, Element semanticObject, String nodeVISUALID) {
        ContainmentHelper containmentHelper = new ContainmentHelper(this.getEditingDomain());
        Element owner = semanticObject.getOwner();
        if (owner == null) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticObject));
        }
        EditPart ownerEditPart = containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), owner);
        if (ownerEditPart != null) {
            return containmentHelper.outlineDropContainedClass((PackageableElement)semanticObject, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticObject));
    }

    protected Command dropChildNodeWithContainmentLink(DropObjectsRequest dropRequest, Element droppedElement, String nodeVISUALID) {
        ContainmentHelper containmentHelper = new ContainmentHelper(this.getEditingDomain());
        CompositeCommand cc = new CompositeCommand(CONTAINED_CLASS_DROP_TO_COMPARTMENT);
        cc.add((IUndoableOperation)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)droppedElement));
        EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (!(droppedElement instanceof Element) || !((Element)graphicalParent).getOwnedElements().contains((Object)droppedElement)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), droppedElement) != null) {
            EditPart editpart = containmentHelper.findEditPartFor(this.getViewer().getEditPartRegistry(), droppedElement);
            View droppedView = (View)editpart.getModel();
            containmentHelper.deleteIncomingContainmentLinksFor(cc, droppedView);
            cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), droppedView));
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected Command dropConstraintNode(DropObjectsRequest dropRequest, Constraint droppedConstraint, String nodeVISUALID) {
        ICommand dropConstraintCommand = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)droppedConstraint, dropRequest);
        if (droppedConstraint.getContext() != null) {
            ShowConstraintContextLink showConstraintContextLink = new ShowConstraintContextLink(this.getEditingDomain(), (GraphicalEditPart)this.getHost(), droppedConstraint);
            dropConstraintCommand = dropConstraintCommand.compose((IUndoableOperation)showConstraintContextLink);
        }
        return GMFtoGEFCommandWrapper.wrap((ICommand)dropConstraintCommand);
    }

    protected Command dropAsNormalBinaryLink(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection sources = this.linkmappingHelper.getSource(semanticLink);
        Collection targets = this.linkmappingHelper.getTarget(semanticLink);
        if (sources.size() == 0 || targets.size() == 0) {
            return UnexecutableCommand.INSTANCE;
        }
        Element source = (Element)sources.toArray()[0];
        Element target = (Element)targets.toArray()[0];
        CompositeCommand cc = new CompositeCommand("");
        this.dropBinaryLink(cc, source, target, linkVISUALID, dropRequest.getLocation(), semanticLink);
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Iterator editPartsIter = request.getEditParts().iterator();
        while (editPartsIter.hasNext()) {
            if (!(editPartsIter.next() instanceof RedefinableTemplateSignatureEditPart)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        editPartsIter = request.getEditParts().iterator();
        boolean containsLabelEditpart = false;
        while (editPartsIter.hasNext() && !containsLabelEditpart) {
            EditPart currentEditPart = (EditPart)editPartsIter.next();
            if (!(currentEditPart instanceof ITextAwareEditPart) || !(currentEditPart instanceof IPrimaryEditPart)) continue;
            containsLabelEditpart = true;
        }
        if (containsLabelEditpart && this.getHost() instanceof DiagramEditPart) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"add children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        Command cmd = this.getHost().getCommand((Request)req);
        if (cmd == null || !cmd.canExecute()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return cmd;
    }
}

