/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.profile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.ProfileUtil;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.profile.IMoveProfileMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.MoveProfileDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class MoveProfileMigrator
extends AbstractMigrator
implements IMoveProfileMigrator {
    private Profile movedProfile;
    private Package newContainer;

    public MoveProfileMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        Object element;
        return TreeNodeUtils.isMoveChange(treeNode) && (element = TreeNodeUtils.getMovedElement(treeNode)) instanceof Profile && element == MigratorProfileApplication.appliedProfile;
    }

    @Override
    public boolean isValid() {
        return MoveProfileMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        Profile nearestProfile;
        if (this.isDisplayDialogPreference() && MigratorProfileApplication.profiledModel.getProfileApplication(nearestProfile = ProfileUtil.getNearestProfile((Element)this.newContainer)) == null) {
            MoveProfileDialog dialog = new MoveProfileDialog(Display.getDefault().getActiveShell(), this.movedProfile, nearestProfile);
            dialog.open();
            if (dialog.isReapply()) {
                MigratorProfileApplication.profiledModel.applyProfile(this.movedProfile);
            } else {
                ArrayList<Stereotype> ownedStereotype = new ArrayList<Stereotype>();
                ProfileUtil.findAllStereotypes((Package)this.movedProfile, ownedStereotype);
                for (Stereotype stereotype : ownedStereotype) {
                    List<StereotypeApplicationDescriptor> list = StereotypeApplicationRegistry.getStereotypeApplicationDescriptors(stereotype);
                    for (StereotypeApplicationDescriptor descriptor : list) {
                        descriptor.getOwner().unapplyStereotype(descriptor.getStereotype());
                    }
                    StereotypeApplicationRegistry.stereotypeApplicationList.removeAll(list);
                }
            }
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            this.movedProfile = (Profile)TreeNodeUtils.getMovedElement(this.treeNode);
            this.newContainer = (Package)TreeNodeUtils.getMovedTargetContainer(this.treeNode);
        }
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("ProfileMove");
    }

    @Override
    public Element getTargetContainer() {
        return this.newContainer;
    }

    @Override
    public Element getSourceContainer() {
        return (Element)TreeNodeUtils.getMovedSourceContainer(this.treeNode, MigratorProfileApplication.comparison);
    }

    @Override
    public Element getMovedElement() {
        return this.movedProfile;
    }

    @Override
    public Profile getProfile() {
        return this.movedProfile;
    }
}

