/*****************************************************************************
 * Copyright (c) 2013 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *
 *		CEA LIST - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.infra.gmfdiag.properties.util;

/**
 *
 *
 * This class provides the constants used in the declaration of the property view for Rulers and Grid
 */
public class RulersAndGridPropertyConstants {

	private RulersAndGridPropertyConstants() {
		// to prevent instanciation
	}

	/**
	 * the edited data
	 */
	public static final String GRID_IS_DISPLAYING_GRID = "grid.isDisplayingGrid";

	public static final String RULERS_IS_DISPLAYING_RULER = "rulers.isDisplayingRulers";

	public static final String GRID_IS_IN_FRONT = "grid.isInFront";

	public static final String GRID_COLOR = "grid.color";

	public static final String GRID_STYLE = "grid.style";

	public static final String GRID_SPACING = "grid.spacing";

	public static final String GRID_IS_SNAP_TO_GRID = "grid.isSnapToGrid";

	public static final String GRID_IS_SNAP_TO_SHAPE = "grid.isSnapToShapes";

	public static final String RULERS_UNITS = "rulers.units";
}
