/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.dialogs.CreateInstanceDialog;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui.AbstractNaryEditingDialog;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.ui.AssignableValuesContentProvider;
import org.eclipse.papyrus.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaryReferenceEditingDialog<T extends EObject>
extends AbstractNaryEditingDialog<T> {
    private Button addButton;
    private Button removeButton;
    private Button addAllButton;
    private Button removeAllButton;
    private Button upButton;
    private Button downButton;
    private static final int NUM_COLUMNS = 4;
    private TreeViewer availableValuesTreeViewer;
    private ListViewer featureValuesListViewer;
    private Button createInstanceButton;
    private AssignableValuesContentProvider assignableValuesContentProvider;
    private final List<T> availableValues;

    public NaryReferenceEditingDialog(Shell shell, List<T> values, List<T> availableValues, IModelCellEditHandler editHandler, EObject eObject, EStructuralFeature feature) {
        super(shell, values, editHandler, eObject, feature);
        this.availableValues = new ArrayList<T>(availableValues);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.NaryReferenceEditingDialog_shellTitle, (Object)this.getFeature().getName(), (Object)this.geteObject().eClass().getName()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 4;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createLeftPane(contents);
        this.createMiddleButtonsPane(contents);
        this.createRightPane(contents);
        this.createRightButtonsPane(contents);
        this.availableValuesTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (NaryReferenceEditingDialog.this.addButton.isEnabled()) {
                    NaryReferenceEditingDialog.this.addButton.notifyListeners(13, null);
                }
            }
        });
        this.featureValuesListViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (NaryReferenceEditingDialog.this.removeButton.isEnabled()) {
                    NaryReferenceEditingDialog.this.removeButton.notifyListeners(13, null);
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.upButtonClicked();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.downButtonClicked();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.addButtonClicked();
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.addAllButtonClicked();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.removeButtonClicked();
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NaryReferenceEditingDialog.this.removeAllButtonClicked();
            }
        });
        if (this.createInstanceButton != null) {
            this.createInstanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NaryReferenceEditingDialog.this.createInstanceButtonClicked();
                }
            });
        }
        return contents;
    }

    private void addButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.availableValuesTreeViewer.getSelection();
        if (selection.isEmpty() || !this.confirmMove()) {
            return;
        }
        Iterator<T> it = this.getTCastedStructuredSelectionIterator(selection);
        while (it.hasNext()) {
            EObject element = (EObject)it.next();
            if (this.getValues() != null && this.getValues().contains(element)) continue;
            this.getValues().add(element);
            this.availableValues.remove(element);
        }
        this.refresh();
        this.featureValuesListViewer.setSelection((ISelection)selection);
    }

    private Iterator<T> getTCastedStructuredSelectionIterator(IStructuredSelection selection) {
        return selection.iterator();
    }

    private void addAllButtonClicked() {
        if (this.availableValues.isEmpty() || !this.confirmMove()) {
            return;
        }
        this.getValues().addAll(this.availableValues);
        this.availableValues.removeAll(this.getValues());
        this.refresh();
    }

    private void removeButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.featureValuesListViewer.getSelection();
        if (selection.isEmpty() || !this.confirmRemove()) {
            return;
        }
        Iterator<T> it = this.getTCastedStructuredSelectionIterator(selection);
        while (it.hasNext()) {
            EObject element = (EObject)it.next();
            if (!this.getValues().contains(element)) continue;
            this.availableValues.add(element);
            this.getValues().remove(element);
        }
        this.refresh();
    }

    private void removeAllButtonClicked() {
        if (this.getValues().isEmpty() || !this.confirmRemove()) {
            return;
        }
        this.availableValues.addAll(this.getValues());
        this.getValues().removeAll(this.getValues());
        this.refresh();
    }

    private boolean confirmRemove() {
        EReference eReference;
        if (this.getFeature() instanceof EReference && (eReference = (EReference)this.getFeature()).isContainment()) {
            return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NaryReferenceEditingDialog_deleteElements, (String)Messages.NaryReferenceEditingDialog_deleteElementsLong);
        }
        return true;
    }

    private boolean confirmMove() {
        EReference reference;
        if ((this.getFeature() instanceof EReference || this.getFeature() instanceof FacetReference) && (reference = (EReference)this.getFeature()).isContainment()) {
            String fullMessage = Messages.NaryReferenceEditingDialog_moveWarning;
            return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NaryReferenceEditingDialog_moveElement, (String)fullMessage);
        }
        return true;
    }

    private void createInstanceButtonClicked() {
        EClassifier eType = this.getFeature().getEType();
        if (eType instanceof EClass) {
            EClass eClass = (EClass)eType;
            EObject newInstance = CreateInstanceDialog.open((Shell)this.getShell(), (EClass)eClass, (LabelProvider)new CustomizableLabelProvider());
            if (newInstance != null) {
                this.getValues().add(newInstance);
                this.refresh();
            }
        }
    }

    private void createLeftPane(Composite contents) {
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(Messages.NaryReferenceEditingDialog_availableValues);
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        final Text patternText = this.createFilterText(choiceComposite);
        Tree availableValuesTree = new Tree(choiceComposite, 2050);
        GridData availableValuesGridData = new GridData();
        availableValuesGridData.widthHint = 200;
        availableValuesGridData.heightHint = 250;
        availableValuesGridData.horizontalAlignment = 4;
        availableValuesGridData.verticalAlignment = 4;
        availableValuesGridData.grabExcessHorizontalSpace = true;
        availableValuesGridData.grabExcessVerticalSpace = true;
        availableValuesTree.setLayoutData((Object)availableValuesGridData);
        this.availableValuesTreeViewer = new TreeViewer(availableValuesTree);
        this.assignableValuesContentProvider = new AssignableValuesContentProvider();
        this.availableValuesTreeViewer.setContentProvider((IContentProvider)this.assignableValuesContentProvider);
        this.availableValuesTreeViewer.setLabelProvider((IBaseLabelProvider)new CustomizableLabelProvider());
        final PatternFilter filter = new PatternFilter();
        this.availableValuesTreeViewer.addFilter((ViewerFilter)filter);
        this.availableValuesTreeViewer.setInput(this.availableValues);
        patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(patternText.getText());
                NaryReferenceEditingDialog.this.availableValuesTreeViewer.refresh();
            }
        });
    }

    private void createMiddleButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 0x1000000;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText(Messages.NaryReferenceEditingDialog_add);
        this.addButton.setToolTipText(Messages.NaryReferenceEditingDialog_addTooltip);
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.removeButton = new Button(buttonsComposite, 8);
        this.removeButton.setText(Messages.NaryReferenceEditingDialog_remove);
        this.removeButton.setToolTipText(Messages.NaryReferenceEditingDialog_removeTooltip);
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        this.spacer(buttonsComposite);
        this.addAllButton = new Button(buttonsComposite, 8);
        this.addAllButton.setText(Messages.NaryReferenceEditingDialog_addAll);
        this.addAllButton.setToolTipText(Messages.NaryReferenceEditingDialog_addAllTooltip);
        this.removeAllButton = new Button(buttonsComposite, 8);
        this.removeAllButton.setText(Messages.NaryReferenceEditingDialog_removeAll);
        this.removeAllButton.setToolTipText(Messages.NaryReferenceEditingDialog_removeAllTooltip);
    }

    private void spacer(Composite parent) {
        Label label = new Label(parent, 0);
    }

    private void createRightButtonsPane(Composite contents) {
        EReference eReference;
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 4;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.spacer(buttonsComposite);
        if (this.getFeature() instanceof EReference && (eReference = (EReference)this.getFeature()).isContainment()) {
            this.createInstanceButton = new Button(buttonsComposite, 8);
            this.createInstanceButton.setText(Messages.NaryReferenceEditingDialog_newInstance);
            GridData createButtonGridData = new GridData();
            createButtonGridData.verticalAlignment = 4;
            createButtonGridData.horizontalAlignment = 4;
            this.createInstanceButton.setLayoutData((Object)createButtonGridData);
            this.spacer(buttonsComposite);
        }
        this.upButton = new Button(buttonsComposite, 8);
        this.upButton.setText(Messages.NaryReferenceEditingDialog_up);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(buttonsComposite, 8);
        this.downButton.setText(Messages.NaryReferenceEditingDialog_down);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
    }

    private void createRightPane(Composite contents) {
        Composite featureComposite = new Composite(contents, 0);
        GridData featureCompositeData = new GridData(4, 4, true, true);
        featureCompositeData.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)featureCompositeData);
        GridLayout featureCompositeLayout = new GridLayout();
        featureCompositeData.horizontalAlignment = 4;
        featureCompositeLayout.marginHeight = 0;
        featureCompositeLayout.marginWidth = 0;
        featureCompositeLayout.numColumns = 1;
        featureComposite.setLayout((Layout)featureCompositeLayout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(Messages.NaryReferenceEditingDialog_values);
        GridData valuesLabelGridData = new GridData();
        valuesLabelGridData.horizontalSpan = 2;
        valuesLabelGridData.horizontalAlignment = 4;
        valuesLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)valuesLabelGridData);
        org.eclipse.swt.widgets.List availableValuesList = new org.eclipse.swt.widgets.List(featureComposite, 2562);
        GridData availableValuesGridData = new GridData();
        availableValuesGridData.widthHint = 200;
        availableValuesGridData.heightHint = 250;
        availableValuesGridData.verticalAlignment = 4;
        availableValuesGridData.horizontalAlignment = 4;
        availableValuesGridData.grabExcessHorizontalSpace = true;
        availableValuesGridData.grabExcessVerticalSpace = true;
        availableValuesList.setLayoutData((Object)availableValuesGridData);
        this.featureValuesListViewer = new ListViewer(availableValuesList);
        this.featureValuesListViewer.setContentProvider((IContentProvider)new AbstractNaryEditingDialog.AssignedValuesContentProvider(this));
        this.featureValuesListViewer.setLabelProvider((IBaseLabelProvider)new CustomizableLabelProvider());
        this.featureValuesListViewer.setInput(this.getValues());
    }

    private Text createFilterText(Composite contents) {
        Text patternText = new Text(contents, 2176);
        patternText.setMessage(Messages.NaryReferenceEditingDialog_typeFilterText);
        patternText.setLayoutData((Object)new GridData(768));
        return patternText;
    }

    @Override
    public void refresh() {
        this.availableValuesTreeViewer.refresh();
        this.featureValuesListViewer.refresh();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    @Override
    public ISelection getSelection() {
        return this.featureValuesListViewer.getSelection();
    }
}

