/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Fanch BONNABESSE (ALL4TEC) fanch.bonnabesse@all4tec.net - Initial API and implementation
 *****************************************************************************/

package org.eclipse.papyrus.views.references.constants;

/**
 * Class used to store all the constants for the plug-in 'views.references'
 */
public interface ReferencesViewConstants {

	/**
	 * The default empty String
	 */
	public static final String EMPTY_STRING = ""; //$NON-NLS-1$

	/**
	 * The name of the ToggleLinking setting.
	 */
	public static final String TOGGLE_LINKING = "ToggleLinking"; //$NON-NLS-1$

	/**
	 * The name of the image used for a collapse all action.
	 */
	public static final String ICON_COLLAPSE_ALL = "icons/full/elcl16/collapseall.gif"; //$NON-NLS-1$

	/**
	 * The name of the image used for an expand all action.
	 */
	public static final String ICON_EXPAND_ALL = "icons/full/elcl16/expandall.gif"; //$NON-NLS-1$

	/**
	 * The name of the image used for a Refresh action.
	 */
	public static final String ICON_REFRESH = "icons/full/elcl16/refresh.gif"; //$NON-NLS-1$

	/**
	 * The name of the image used for a Clear All action.
	 */
	public static final String ICON_CLEAR_ALL = "icons/full/elcl16/search_remall.gif"; //$NON-NLS-1$

	/**
	 * The name of the image used for a Link with Editor action.
	 */
	public static final String ICON_LINK_WITH_EDITOR = "icons/full/elcl16/synced.png"; //$NON-NLS-1$

	/**
	 * The name of the image used for a Go To action.
	 */
	public static final String ICON_GO_TO = "icons/full/elcl16/search_goto.gif"; //$NON-NLS-1$

	/**
	 * The name of the form when the selection is multiple.
	 */
	public static final String NAME_FORM_MULTI_SELECTION = "N/A"; //$NON-NLS-1$

	/**
	 * 'Element' value for the name of the EStructuralFeature.
	 */
	public static final String NAME_ELEMENT = "element"; //$NON-NLS-1$

	/**
	 * SEPARATOR for the LabelProvider '::'.
	 */
	public static final String SEPARATOR = "::"; //$NON-NLS-1$

	/**
	 * Id of the Plug-In 'org.eclipse.ui'.
	 */
	public static final String PLUGIN_ORG_ECLIPSE_UI = "org.eclipse.ui"; //$NON-NLS-1$

	/**
	 * Id of the Plug-In 'org.eclipse.search'.
	 */
	public static final String PLUGIN_ORG_ECLIPSE_SEARCH = "org.eclipse.search"; //$NON-NLS-1$
}
