/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.strategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class ProviderBasedBrowseStrategy<T extends Viewer>
extends EncapsulatedContentProvider
implements TreeBrowseStrategy {
    protected ITreeContentProvider provider;
    protected boolean filterElements = false;
    protected final Map<Object, Boolean> cache = new HashMap<Object, Boolean>();
    protected final Map<Object, Boolean> visibleChildCache = new HashMap<Object, Boolean>();
    protected T viewer;

    public ProviderBasedBrowseStrategy(ITreeContentProvider provider) {
        this.setProvider(provider);
    }

    public ProviderBasedBrowseStrategy() {
    }

    public void setProvider(ITreeContentProvider provider) {
        this.encapsulated = provider;
        this.provider = provider;
        this.filterElements = provider instanceof IHierarchicContentProvider;
        this.clearCache();
    }

    @Override
    public Object[] getElements() {
        return this.getValidElements(super.getElements());
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getValidElements(super.getElements(inputElement));
    }

    protected Object[] getValidElements(Object[] roots) {
        this.clearCache();
        if (this.filterElements) {
            List rootsList = ListHelper.asList((Object[])roots);
            Iterator iterator = rootsList.iterator();
            while (iterator.hasNext()) {
                if (this.isValid(iterator.next(), new HashSet<Object>())) continue;
                iterator.remove();
            }
            return rootsList.toArray();
        }
        return roots;
    }

    @Override
    public Object[] getChildren(Object parent) {
        if (this.provider == null) {
            Activator.log.warn("The provider has not been initialized");
            return new Object[0];
        }
        return this.getValidElements(super.getChildren(parent));
    }

    @Override
    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    protected boolean isValid(Object containerElement, Set<Object> visitedElements) {
        if (!this.cache.containsKey(containerElement)) {
            boolean isVisible = this.browseElement(containerElement) ? this.isValidValue(containerElement) || this.hasOneVisibleChild(containerElement, visitedElements) : false;
            this.cache.put(containerElement, isVisible);
        }
        return this.cache.get(containerElement);
    }

    protected boolean browseElement(Object containerElement) {
        return true;
    }

    protected boolean hasOneVisibleChild(Object element, Set<Object> visitedElements) {
        if (!this.visibleChildCache.containsKey(element)) {
            boolean result = false;
            if (visitedElements.add(this.getAdaptedValue(element))) {
                Object[] objectArray = super.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.isValid(child, visitedElements)) {
                        result = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.visibleChildCache.put(element, result);
        }
        return this.visibleChildCache.get(element);
    }

    @Override
    public TreePath findPath(Object semanticElement, Object[] rootElements) {
        return TreePath.EMPTY;
    }

    protected void clearCache() {
        this.cache.clear();
        this.visibleChildCache.clear();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
    }

    @Override
    public void revealSemanticElement(List<?> elementsToReveal) {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(elementsToReveal), true);
        }
    }
}

