/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.emf.type.core.AdviceBindingAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.AdviceBindingRemovedEvent;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRemovedEvent;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeRegistryListener;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeRegistryListener2;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;

public class CacheRegistry
implements IElementTypeRegistryListener2 {
    private static CacheRegistry instance;
    private final Map<IClientContext, Map<IElementType, IEditHelperAdvice[]>> clientContextToTypeAndAdvices = new HashMap<IClientContext, Map<IElementType, IEditHelperAdvice[]>>();

    private CacheRegistry() {
    }

    public static synchronized CacheRegistry getInstance() {
        if (instance == null) {
            instance = new CacheRegistry();
            ElementTypeRegistry.getInstance().addElementTypeRegistryListener((IElementTypeRegistryListener)instance);
        }
        return instance;
    }

    public IEditHelperAdvice[] getMatchingAdvice(IClientContext context, IElementType type) {
        IEditHelperAdvice[] result;
        Map<IElementType, IEditHelperAdvice[]> typeToAdvices = this.clientContextToTypeAndAdvices.get(context);
        if (typeToAdvices == null) {
            typeToAdvices = new HashMap<IElementType, IEditHelperAdvice[]>();
            this.clientContextToTypeAndAdvices.put(context, typeToAdvices);
        }
        if ((result = typeToAdvices.get(type)) == null) {
            result = ElementTypeRegistry.getInstance().getEditHelperAdvice(type, context);
            typeToAdvices.put(type, result);
        }
        return result;
    }

    public IEditHelperAdvice[] getEditHelperAdvice(IClientContext clientContext, IElementType type) {
        IEditHelperAdvice[] result;
        Map<IElementType, IEditHelperAdvice[]> typeToAdvices = this.clientContextToTypeAndAdvices.get(clientContext);
        if (typeToAdvices == null) {
            typeToAdvices = new HashMap<IElementType, IEditHelperAdvice[]>();
            this.clientContextToTypeAndAdvices.put(clientContext, typeToAdvices);
        }
        if ((result = typeToAdvices.get(type)) == null) {
            result = ElementTypeRegistry.getInstance().getEditHelperAdvice(type, clientContext);
            typeToAdvices.put(type, result);
        }
        return result;
    }

    public void elementTypeAdded(ElementTypeAddedEvent elementTypeAddedEvent) {
        this.flushCache();
    }

    public void elementTypeRemoved(ElementTypeRemovedEvent event) {
        this.flushCache();
    }

    public void adviceBindingAdded(AdviceBindingAddedEvent event) {
        this.flushCache();
    }

    public void adviceBindingRemoved(AdviceBindingRemovedEvent event) {
        this.flushCache();
    }

    protected void flushCache() {
        this.clientContextToTypeAndAdvices.clear();
    }
}

