/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.CombinedFragmentFigure;

public class InteractionOperandFigure
extends RoundedCompartmentFigure {
    private boolean lineSeparator = true;
    private boolean firstOperand = false;
    private WrappingLabel fInteractionConstraintLabel;

    public InteractionOperandFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setLineStyle(2);
        this.setBorder(null);
        this.setLineSeparator(!this.firstOperand);
        this.createContents();
    }

    public WrappingLabel getInteractionConstraintLabel() {
        return this.fInteractionConstraintLabel;
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.lineSeparator) {
            graphics.setLineStyle(this.getLineStyle());
            graphics.setLineWidth(this.getLineWidth());
            graphics.drawLine(this.getBounds().getTopLeft(), this.getBounds().getTopRight());
        }
    }

    public void setLineSeparator(boolean lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private void createContents() {
        this.fInteractionConstraintLabel = new WrappingLabel();
        this.fInteractionConstraintLabel.setText("");
        this.add((IFigure)this.fInteractionConstraintLabel, new Rectangle(10, 10, 200, 20));
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension dim = super.getMinimumSize(wHint, hHint);
        IFigure cfFigure = this.getParent();
        while (!(cfFigure instanceof CombinedFragmentFigure)) {
            cfFigure = cfFigure.getParent();
        }
        if (cfFigure == null) {
            return dim;
        }
        Rectangle ccfbound = cfFigure.getBounds();
        if (ccfbound.width != -1) {
            return new Dimension(ccfbound.width, dim.height);
        }
        return dim;
    }
}

