/*****************************************************************************
 * Copyright (c) 2014, 2017 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Patrick Tessier (CEA LIST) Patrick.tessier@cea.fr - Initial API and implementation
 *  Fanch BONNABESSE (ALL4TEC) fanch.bonnabesse@all4tec.net - Bug 515201
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.clazz.custom.edit.part;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.AssociationEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.util.AssociationUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;


public class CustomUMLDiagramUpdater extends UMLDiagramUpdater {

	public static final CustomUMLDiagramUpdater INSTANCE = new CustomUMLDiagramUpdater();

	private CustomUMLDiagramUpdater() {
		// to prevent instantiation
		super();
	}

	@Override
	protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Association_Edge(Package container) {
		LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
		for (Iterator<?> links = container.getPackagedElements().iterator(); links.hasNext();) {
			EObject linkObject = (EObject) links.next();
			if (false == linkObject instanceof Association) {
				continue;
			}
			Association link = (Association) linkObject;
			if (!AssociationEditPart.VISUAL_ID.equals(UMLVisualIDRegistry.getLinkWithClassVisualID(link))) {
				continue;
			}
			List<?> targets = link.getEndTypes();
			Object theTarget = targets.size() >= 2 ? targets.get(1) : null;
			if (false == theTarget instanceof Type) {
				continue;
			}
			Type dst = (Type) theTarget;
			List<?> sources = link.getEndTypes();
			Object theSource = sources.size() >= 2 ? sources.get(0) : null;
			if (false == theSource instanceof Type) {
				continue;
			}
			Type src = (Type) theSource;
			result.add(new UMLLinkDescriptor(src, dst, link, UMLElementTypes.Association_Edge, AssociationEditPart.VISUAL_ID));
		}
		return result;
	}

	@Override
	protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Association_Edge(Type target, CrossReferenceAdapter crossReferencer) {
		return new TypeModelFacetLinksRetriever_Association_Edge(target) {

			@Override
			protected boolean check(Type source, Type target) {
				return getRoot() == target;
			}
		}.getTypeModelFacetLinks_Association_Edge();
	}

	@Override
	protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Association_Edge(Type source) {
		return new TypeModelFacetLinksRetriever_Association_Edge(source) {

			@Override
			protected boolean check(Type source, Type target) {
				return getRoot() == source;
			}
		}.getTypeModelFacetLinks_Association_Edge();
	}

	private abstract static class TypeModelFacetLinksRetriever_Association_Edge {
		private final Type myRoot;

		public TypeModelFacetLinksRetriever_Association_Edge(Type root) {
			myRoot = root;
		}

		public Collection<UMLLinkDescriptor> getTypeModelFacetLinks_Association_Edge() {
			Package container = null;
			// Find container element for the link.
			// Climb up by containment hierarchy starting from the source
			// and return the first element that is instance of the container class.
			for (EObject element = myRoot; element != null && container == null; element = element.eContainer()) {
				if (element instanceof Package) {
					container = (Package) element;
				}
			}
			if (container == null) {
				return Collections.emptyList();
			}
			LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
			for (Iterator<?> links = container.getPackagedElements().iterator(); links.hasNext();) {
				EObject linkObject = (EObject) links.next();
				if (false == linkObject instanceof Association) {
					continue;
				}
				Association link = (Association) linkObject;
				if (!AssociationEditPart.VISUAL_ID.equals(UMLVisualIDRegistry.getLinkWithClassVisualID(link))) {
					continue;
				}
				List<?> ends = link.getEndTypes();
				if (ends == null || ends.isEmpty()) {
					continue;
				}
				Object theTarget = ends.size() == 2 ? AssociationUtil.getInitialTargetFirstEnd(link).getType() : AssociationUtil.getInitialSourceSecondEnd(link).getType();
				if (false == theTarget instanceof Type) {
					continue;
				}
				Type dst = (Type) theTarget;
				Object theSource = AssociationUtil.getInitialSourceSecondEnd(link).getType();
				if (false == theSource instanceof Type) {
					continue;
				}
				Type src = (Type) theSource;
				if (!check(src, dst)) {
					continue;
				}
				result.add(new UMLLinkDescriptor(src, dst, link, UMLElementTypes.Association_Edge, AssociationEditPart.VISUAL_ID));
			}
			return result;
		}

		protected Type getRoot() {
			return myRoot;
		}

		protected abstract boolean check(Type source, Type target);
	}
}
