/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.ICellAxisWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.IdAxisWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.NattableproblemFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.NattableproblemPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.StringResolutionProblem;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.paste.ReferenceValueSetter;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.ui.converter.StringValueConverterStatus;

public class CellHelper {
    private CellHelper() {
    }

    public static final void createStringResolutionProblem(INattableModelManager tableManager, Object columnElement, Object rowElement, String pastedText, ConvertedValueContainer<?> valueContainer, Map<?, ?> sharedMap) {
        IStatus status = valueContainer.getStatus();
        if (!status.isOK() && status.matches(4)) {
            List references = (List)sharedMap.get("referencesToSet");
            if (status.matches(4)) {
                Cell cell = tableManager.getCell(columnElement, rowElement);
                if (cell == null) {
                    cell = NattablecellFactory.eINSTANCE.createCell();
                    Object column = AxisUtils.getRepresentedElement(columnElement);
                    IdAxisWrapper columnWrapper = null;
                    if (column instanceof String) {
                        columnWrapper = NattablecellFactory.eINSTANCE.createIdAxisWrapper();
                        columnWrapper.setElement((String)column);
                    } else if (column instanceof EObject) {
                        columnWrapper = NattablecellFactory.eINSTANCE.createEObjectAxisWrapper();
                        ReferenceValueSetter structure = new ReferenceValueSetter((EObject)columnWrapper, NattablecellPackage.eINSTANCE.getEObjectAxisWrapper_Element(), column);
                        references.add(structure);
                    }
                    Object row = AxisUtils.getRepresentedElement(rowElement);
                    IdAxisWrapper rowWrapper = null;
                    if (row instanceof String) {
                        rowWrapper = NattablecellFactory.eINSTANCE.createIdAxisWrapper();
                        rowWrapper.setElement((String)row);
                    } else if (row instanceof EObject) {
                        rowWrapper = NattablecellFactory.eINSTANCE.createEObjectAxisWrapper();
                        ReferenceValueSetter structure = new ReferenceValueSetter((EObject)rowWrapper, NattablecellPackage.eINSTANCE.getEObjectAxisWrapper_Element(), row);
                        references.add(structure);
                    }
                    if (rowWrapper == null || columnWrapper == null) {
                        throw new UnsupportedOperationException("Case not managed");
                    }
                    cell.setColumnWrapper((ICellAxisWrapper)columnWrapper);
                    cell.setRowWrapper((ICellAxisWrapper)rowWrapper);
                    List cells = (List)sharedMap.get("cellsToAdd");
                    cells.add(cell);
                }
                StringResolutionProblem problem = NattableproblemFactory.eINSTANCE.createStringResolutionProblem();
                problem.setName("Set Value As Text Problem");
                problem.setDescription(status.getMessage());
                problem.setValueAsString(pastedText);
                if (status instanceof StringValueConverterStatus) {
                    problem.getUnresolvedString().addAll(((StringValueConverterStatus)status).getUnresolvedString());
                }
                if (cell.eContainer() == null) {
                    cell.eSet((EStructuralFeature)NattablecellPackage.eINSTANCE.getCell_Problems(), Collections.singleton(problem));
                } else {
                    ReferenceValueSetter structure = new ReferenceValueSetter((EObject)cell, NattablecellPackage.eINSTANCE.getCell_Problems(), problem);
                    references.add(structure);
                }
            }
        }
    }

    public static final Command getCreateStringResolutionProblemCommand(TransactionalEditingDomain domain, INattableModelManager tableManager, Object columnElement, Object rowElement, String pastedText, ConvertedValueContainer<?> valueContainer) {
        IStatus status = valueContainer.getStatus();
        if (!status.isOK() && status.matches(4)) {
            IElementEditService provider;
            CompositeCommand command = new CompositeCommand("Create Cell For Error Command");
            Cell cell = tableManager.getCell(columnElement, rowElement);
            if (cell == null) {
                Table table = tableManager.getTable();
                cell = NattablecellFactory.eINSTANCE.createCell();
                SetRequest request = new SetRequest(domain, (EObject)table, (EStructuralFeature)NattablePackage.eINSTANCE.getTable_Cells(), (Object)cell);
                provider = ElementEditServiceUtils.getCommandProvider((EObject)table);
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                Object column = AxisUtils.getRepresentedElement(columnElement);
                IdAxisWrapper columnWrapper = null;
                if (column instanceof String) {
                    columnWrapper = NattablecellFactory.eINSTANCE.createIdAxisWrapper();
                    provider = ElementEditServiceUtils.getCommandProvider((EObject)columnWrapper);
                    request = new SetRequest(domain, (EObject)columnWrapper, (EStructuralFeature)NattablecellPackage.eINSTANCE.getIdAxisWrapper_Element(), column);
                    command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                } else if (column instanceof EObject) {
                    columnWrapper = NattablecellFactory.eINSTANCE.createEObjectAxisWrapper();
                    provider = ElementEditServiceUtils.getCommandProvider((EObject)columnWrapper);
                    request = new SetRequest(domain, (EObject)columnWrapper, (EStructuralFeature)NattablecellPackage.eINSTANCE.getEObjectAxisWrapper_Element(), column);
                    command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                }
                Object row = AxisUtils.getRepresentedElement(rowElement);
                IdAxisWrapper rowWrapper = null;
                if (row instanceof String) {
                    rowWrapper = NattablecellFactory.eINSTANCE.createIdAxisWrapper();
                    provider = ElementEditServiceUtils.getCommandProvider((EObject)rowWrapper);
                    request = new SetRequest(domain, (EObject)rowWrapper, (EStructuralFeature)NattablecellPackage.eINSTANCE.getIdAxisWrapper_Element(), row);
                    command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                } else if (row instanceof EObject) {
                    rowWrapper = NattablecellFactory.eINSTANCE.createEObjectAxisWrapper();
                    provider = ElementEditServiceUtils.getCommandProvider((EObject)rowWrapper);
                    request = new SetRequest(domain, (EObject)rowWrapper, (EStructuralFeature)NattablecellPackage.eINSTANCE.getEObjectAxisWrapper_Element(), row);
                    command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                }
                if (rowWrapper == null || columnWrapper == null) {
                    throw new UnsupportedOperationException("Case not managed");
                }
                provider = ElementEditServiceUtils.getCommandProvider((EObject)cell);
                request = new SetRequest(domain, (EObject)cell, (EStructuralFeature)NattablecellPackage.eINSTANCE.getCell_ColumnWrapper(), (Object)columnWrapper);
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                request = new SetRequest(domain, (EObject)cell, (EStructuralFeature)NattablecellPackage.eINSTANCE.getCell_RowWrapper(), (Object)rowWrapper);
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            }
            EList problems = cell.getProblems();
            StringResolutionProblem problem = null;
            for (Problem current : problems) {
                if (!(current instanceof StringResolutionProblem)) continue;
                problem = (StringResolutionProblem)current;
                break;
            }
            if (problem == null) {
                problem = NattableproblemFactory.eINSTANCE.createStringResolutionProblem();
                problem.setName("Set Value As Text Problem");
                problem.setDescription(status.getMessage());
                problem.setValueAsString(pastedText);
                if (status instanceof StringValueConverterStatus) {
                    problem.getUnresolvedString().addAll(((StringValueConverterStatus)status).getUnresolvedString());
                    SetRequest setProblemRequest = new SetRequest(domain, (EObject)cell, (EStructuralFeature)NattablecellPackage.eINSTANCE.getCell_Problems(), (Object)problem);
                    IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((EObject)cell);
                    command.add((IUndoableOperation)provider2.getEditCommand((IEditCommandRequest)setProblemRequest));
                }
            } else {
                provider = ElementEditServiceUtils.getCommandProvider(problem);
                SetRequest request = new SetRequest(domain, (EObject)problem, (EStructuralFeature)NattableproblemPackage.eINSTANCE.getStringResolutionProblem_ValueAsString(), (Object)pastedText);
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                request = new SetRequest(domain, (EObject)problem, (EStructuralFeature)NattableproblemPackage.eINSTANCE.getStringResolutionProblem_UnresolvedString(), (Object)((StringValueConverterStatus)status).getUnresolvedString());
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                request = new SetRequest(domain, (EObject)problem, (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Description(), (Object)status.getMessage());
                command.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            }
            return new GMFtoEMFCommandWrapper((ICommand)command);
        }
        return null;
    }

    public static final Command getDestroyStringResolutionProblemCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Cell cell = tableManager.getCell(columnElement, rowElement);
        CompoundCommand removeProblemCommand = new CompoundCommand("Destroy string problem command");
        if (cell != null && !cell.getProblems().isEmpty()) {
            for (Problem current : cell.getProblems()) {
                if (!(current instanceof StringResolutionProblem)) continue;
                RemoveCommand rc = new RemoveCommand((EditingDomain)domain, (EObject)cell, (EStructuralFeature)NattablecellPackage.eINSTANCE.getCell_Problems(), (Object)current);
                removeProblemCommand.append((Command)rc);
            }
            if (cell.getEAnnotations().isEmpty()) {
                if (cell instanceof StyledElement) {
                    StyledElement styledElement = (StyledElement)cell;
                    if (styledElement.getStyles().isEmpty()) {
                        RemoveCommand rc = new RemoveCommand((EditingDomain)domain, (EObject)tableManager.getTable(), (EStructuralFeature)NattablePackage.eINSTANCE.getTable_Cells(), (Object)cell);
                        removeProblemCommand.append((Command)rc);
                    }
                } else {
                    RemoveCommand rc = new RemoveCommand((EditingDomain)domain, (EObject)tableManager.getTable(), (EStructuralFeature)NattablePackage.eINSTANCE.getTable_Cells(), (Object)cell);
                    removeProblemCommand.append((Command)rc);
                }
            }
        }
        if (!removeProblemCommand.isEmpty()) {
            return removeProblemCommand;
        }
        return null;
    }
}

