/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ElementDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider.IClassBasedTool;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider.IElementTypesBasedTool;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;

public class ExtendedConnectionToolEntry
extends PaletteToolEntry
implements IElementTypesBasedTool,
IClassBasedTool {
    private final List<IElementType> elementTypes = new ArrayList<IElementType>();
    private final List<ElementDescriptor> elementDescriptors;
    private String toolClassName;

    public ExtendedConnectionToolEntry(String id, String label, PaletteFactory factory, List<ElementDescriptor> elementDescriptors) {
        super(id, label, factory);
        this.elementDescriptors = elementDescriptors;
        for (ElementDescriptor elementDescriptor : elementDescriptors) {
            ElementTypeConfiguration elementType = elementDescriptor.getElementType();
            if (elementType == null) continue;
            this.elementTypes.add(ElementTypeRegistry.getInstance().getType(elementType.getIdentifier()));
        }
    }

    @Override
    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    @Override
    public List<ElementDescriptor> getElementDescriptors() {
        return this.elementDescriptors;
    }

    @Override
    public String getToolClassName() {
        return this.toolClassName;
    }

    @Override
    public void setToolClassName(String toolClassName) {
        this.toolClassName = toolClassName;
    }
}

