/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Configuration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider.StackConfigurationItemProvider;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.DragAndDropCompoundCommand;

public class CustomStackConfigurationItemProvider
extends StackConfigurationItemProvider {
    private static final String STACK = "> Stack";

    public CustomStackConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        DragAndDropCompoundCommand command = null;
        Object entry = collection.iterator().next();
        if (entry instanceof ToolEntry) {
            command = new DragAndDropCompoundCommand();
            ToolConfiguration newTool = CreatePaletteItemUtil.createToolConfiguration((PaletteEntry)((ToolEntry)entry), domain.getResourceSet());
            DragAndDropCommand dadCommand = new DragAndDropCommand(domain, owner, location, operations, operation, Collections.singleton(newTool)){

                protected boolean isCrossDomain() {
                    return false;
                }

                public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
                    return super.validate(owner, location, operations, operation, this.collection);
                }

                protected boolean prepareDropMoveOn() {
                    this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)this.collection);
                    if (this.analyzeForNonContainment(this.dropCommand)) {
                        this.dropCommand.dispose();
                        this.dropCommand = UnexecutableCommand.INSTANCE;
                        this.dragCommand = IdentityCommand.INSTANCE;
                    }
                    boolean result = this.dropCommand.canExecute();
                    return result;
                }
            };
            Command commandElemenType = CreatePaletteItemUtil.createElementTypesElement(domain, (ToolEntry)entry, newTool);
            ((CompoundCommand)command).append((Command)dadCommand);
            ((CompoundCommand)command).append(commandElemenType);
        } else {
            command = new DragAndDropCommand(domain, owner, location, operations, operation, collection);
        }
        return command != null && command.canExecute() ? command : UnexecutableCommand.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        return ((StackConfiguration)object).getOwnedConfigurations();
    }

    @Override
    public Object getImage(Object object) {
        Object result = null;
        if (object instanceof Configuration) {
            result = this.overlayImage(object, CreatePaletteItemUtil.iconDescriptorToImage(((Configuration)object).getIcon()));
        }
        return result != null ? result : super.getImage(object);
    }

    @Override
    public String getText(Object object) {
        return STACK;
    }
}

