/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.AbstractPopupBarTool;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.navigation.editpolicy.NavigationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.HyperlinkButton;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class HyperlinkNavigationMenuEditPolicy
extends NavigationEditPolicy {
    private static final String ICONS_NEW_TABLE = "icons/NewTable.gif";
    private static final String ICONS_NEW_DIAGRAM = "icons/NewDiagram.gif";
    private IPageIconsRegistry editorRegistry;
    private HyperLinkManagerShell hyperLinkManagerShell;
    protected LinkedList<HyperLinkObject> hyperLinkObjectList;
    protected HyperLinkHelperFactory hyperlinkHelperFactory;

    public HyperlinkNavigationMenuEditPolicy() {
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        this.hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
    }

    protected void appendNavigationMenuItem() {
        this.clearAppendObjects();
        try {
            this.hyperLinkObjectList = new LinkedList();
            ArrayList unfilteredHyperlinkObjects = this.hyperlinkHelperFactory.getAllreferenced((EModelElement)((IGraphicalEditPart)this.getHost()).getNotationView());
            for (AbstractHyperLinkHelper hyperlinkHelper : this.hyperlinkHelperFactory.getHyperLinkHelpers()) {
                this.hyperLinkObjectList.addAll(hyperlinkHelper.getFilteredObject((List)unfilteredHyperlinkObjects));
            }
            if (this.hyperLinkObjectList.isEmpty()) {
                this.hyperLinkObjectList.addAll(unfilteredHyperlinkObjects);
            } else if (this.hyperLinkObjectList.size() != unfilteredHyperlinkObjects.size()) {
                this.hyperLinkObjectList.clear();
                this.hyperLinkObjectList.addAll(unfilteredHyperlinkObjects);
            }
            this.addHyperlinks();
        }
        catch (HyperLinkException e) {
            Activator.log.error((Throwable)e);
        }
        this.addHyperlinkedViewCreations();
        this.addNavigationMenuHyperlinkDescriptor(Activator.getDefault().getIcon("plus"), (IAction)new AddHyperlinkAction(), Messages.HyperlinkNavigationMenuEditPolicy_EditHyperLinkTooltip, Messages.HyperlinkNavigationMenuEditPolicy_EditHyperLinkTooltipLabel);
    }

    private void addHyperlinkedViewCreations() {
        EObject selection = null;
        Object model = ((IGraphicalEditPart)this.getHost()).getModel();
        if (model instanceof View) {
            View view = (View)model;
            selection = EMFHelper.getEObject((Object)view.getElement());
        }
        if (selection != null) {
            ArrayList<ViewPrototype> diagramPrototypes = new ArrayList<ViewPrototype>();
            ArrayList<ViewPrototype> tablePrototypes = new ArrayList<ViewPrototype>();
            for (ViewPrototype proto : PolicyChecker.getFor((EObject)selection).getPrototypesFor(selection)) {
                if (proto.getRepresentationKind() instanceof PapyrusDiagram) {
                    diagramPrototypes.add(proto);
                    continue;
                }
                if (!(proto.getRepresentationKind() instanceof PapyrusTable)) continue;
                tablePrototypes.add(proto);
            }
            if (diagramPrototypes.size() > 0) {
                Collections.sort(diagramPrototypes, new ViewPrototype.Comp());
                Image addDiagramIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.viewpoints.policy", (String)ICONS_NEW_DIAGRAM).createImage();
                AddViewPopupAction addDiagramAction = new AddViewPopupAction(diagramPrototypes, Messages.HyperlinkNavigationMenuEditPolicy_CreateDiagramDialogLabel, Messages.HyperlinkNavigationMenuEditPolicy_CreateDiagramDialogMessage);
                this.addNavigationMenuHyperlinkDescriptor(addDiagramIcon, (IAction)addDiagramAction, Messages.HyperlinkNavigationMenuEditPolicy_CreateDiagramhyperlinkTooltip, Messages.HyperlinkNavigationMenuEditPolicy_CreateDiagramhyperlinkLabel);
            }
            if (tablePrototypes.size() > 0) {
                Collections.sort(tablePrototypes, new ViewPrototype.Comp());
                Image addTableIcon = Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.viewpoints.policy", (String)ICONS_NEW_TABLE).createImage();
                AddViewPopupAction addTableAction = new AddViewPopupAction(tablePrototypes, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableDialogTitle, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableDialogMessage);
                this.addNavigationMenuHyperlinkDescriptor(addTableIcon, (IAction)addTableAction, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableHyperLinkTooltip, Messages.HyperlinkNavigationMenuEditPolicy_CreateTableHyperLinkLabel);
            }
        }
    }

    private void addHyperlinks() {
        ILabelProvider labelProvider = null;
        boolean localLabelProvider = false;
        try {
            EObject contextElement = EMFHelper.getEObject((Object)this.getHost());
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)contextElement)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            localLabelProvider = true;
        }
        for (HyperLinkObject hyperlink : this.hyperLinkObjectList) {
            String text;
            String tooltip;
            if (labelProvider instanceof CellLabelProvider) {
                text = tooltip = ((CellLabelProvider)labelProvider).getToolTipText((Object)hyperlink);
            } else {
                if (hyperlink instanceof HyperLinkDocument || hyperlink instanceof HyperLinkWeb) {
                    text = hyperlink.getTooltipText();
                    tooltip = labelProvider.getText((Object)hyperlink);
                } else {
                    text = labelProvider.getText((Object)hyperlink);
                    tooltip = hyperlink.getTooltipText();
                }
                if (tooltip == null) {
                    tooltip = text;
                }
                if (text == null) {
                    text = tooltip;
                }
            }
            this.addNavigationMenuHyperlinkDescriptor(labelProvider.getImage((Object)hyperlink), (IAction)new NavigateHyperlinkAction(hyperlink), tooltip, text);
        }
        if (localLabelProvider) {
            labelProvider.dispose();
        }
    }

    protected void addNavigationMenuHyperlinkDescriptor(Image theImage, IAction theAction, String theTip, String theText) {
        if (!(theAction instanceof AbstractPopupBarTool) || ((AbstractPopupBarTool)theAction).isCommandEnabled()) {
            HyperlinkButton desc = new HyperlinkButton(theText, theTip, theImage, theAction);
            this.navigationMenu.getAppendObjects().add(desc);
        }
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected abstract class AbstractHyperlinkAction
    extends Action {
        protected AbstractHyperlinkAction() {
        }
    }

    public class AddHyperlinkAction
    extends AbstractHyperlinkAction {
        public void run() {
            Shell parentShell = EditorHelper.getActiveShell();
            HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell = new HyperLinkManagerShell(parentShell, HyperlinkNavigationMenuEditPolicy.this.getEditorRegistry(), ((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getEditingDomain(), (EModelElement)((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getNotationView().getElement(), (EModelElement)((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getNotationView(), HyperlinkNavigationMenuEditPolicy.this.hyperlinkHelperFactory);
            HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell.setInput(HyperlinkNavigationMenuEditPolicy.this.hyperLinkObjectList);
            parentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    HyperlinkNavigationMenuEditPolicy.this.hyperLinkManagerShell.open();
                }
            });
        }
    }

    public class AddViewPopupAction
    extends Action {
        private List<ViewPrototype> viewPrototypes;
        private String title;
        private String message;
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                String text = null;
                if (element instanceof ViewPrototype) {
                    ViewPrototype prototype = (ViewPrototype)element;
                    text = prototype.getLabel();
                } else {
                    text = super.getText(element);
                }
                return text;
            }

            public Image getImage(Object element) {
                Image image = null;
                image = element instanceof ViewPrototype ? ((ViewPrototype)element).getIconDescriptor().createImage() : super.getImage(element);
                return image;
            }
        };

        public AddViewPopupAction(List<ViewPrototype> diagramPrototypes, String Title, String message) {
            this.viewPrototypes = diagramPrototypes;
            this.title = Title;
            this.message = message;
        }

        public void run() {
            Object firstResult;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(EditorHelper.getActiveShell(), (ILabelProvider)this.labelProvider, (ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance()));
            dialog.setAllowMultiple(false);
            dialog.setTitle(this.title);
            dialog.setMessage(this.message);
            dialog.setInput(this.viewPrototypes);
            dialog.setSize(-1, 10);
            dialog.open();
            if (dialog.getReturnCode() == 0 && (firstResult = dialog.getFirstResult()) instanceof ViewPrototype) {
                ViewPrototype prototype = (ViewPrototype)firstResult;
                new CreateViewAndHyperlinkAction(prototype).run();
            }
        }
    }

    protected class CreateViewAndHyperlinkAction
    extends Action {
        private ViewPrototype prototype;

        public CreateViewAndHyperlinkAction(ViewPrototype prototype) {
            this.prototype = prototype;
        }

        public void run() {
            try {
                View view;
                EObject eObject;
                Object model = ((IGraphicalEditPart)HyperlinkNavigationMenuEditPolicy.this.getHost()).getModel();
                if (model instanceof View && (eObject = EMFHelper.getEObject((Object)(view = (View)model).getElement())) != null) {
                    HashSet<EObject> usagesBefore = new HashSet<EObject>();
                    Collection usages = EMFHelper.getUsages((EObject)eObject);
                    if (usages != null) {
                        for (EStructuralFeature.Setting setting : usages) {
                            usagesBefore.add(setting.getEObject());
                        }
                    }
                    this.prototype.instantiateOn(eObject);
                    HashSet<EObject> usagesAfter = new HashSet<EObject>();
                    usages = EMFHelper.getUsages((EObject)eObject);
                    if (usages != null) {
                        for (EStructuralFeature.Setting setting : usages) {
                            usagesAfter.add(setting.getEObject());
                        }
                    }
                    usagesAfter.removeAll(usagesBefore);
                    EObject container = null;
                    for (EObject createdObject : usagesAfter) {
                        if (createdObject instanceof PapyrusDiagramStyle) {
                            PapyrusDiagramStyle viewStyle = (PapyrusDiagramStyle)createdObject;
                            container = viewStyle.eContainer();
                            continue;
                        }
                        if (container != null) continue;
                        container = createdObject;
                    }
                    if (container != null) {
                        HyperLinkSpecificObject hyperLink = new HyperLinkSpecificObject(container);
                        hyperLink.setIsDefault(true);
                        ArrayList<HyperLinkSpecificObject> hyperLinkList = new ArrayList<HyperLinkSpecificObject>();
                        hyperLinkList.add(hyperLink);
                        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
                        Command addHyperLinkCommand = HyperlinkNavigationMenuEditPolicy.this.hyperlinkHelperFactory.getAddHyperLinkCommand(domain, (EModelElement)model, hyperLinkList);
                        if (addHyperLinkCommand.canExecute()) {
                            domain.getCommandStack().execute(addHyperLinkCommand);
                        }
                    }
                }
            }
            catch (HyperLinkException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected class NavigateHyperlinkAction
    extends AbstractHyperlinkAction {
        private final HyperLinkObject hyperlink;

        public NavigateHyperlinkAction(HyperLinkObject hyperlink) {
            this.hyperlink = hyperlink;
        }

        public void run() {
            if (this.hyperlink.needsOpenCommand()) {
                try {
                    TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)HyperlinkNavigationMenuEditPolicy.this.getHost());
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, this.hyperlink.getTooltipText()){

                        protected void doExecute() {
                            NavigateHyperlinkAction.this.hyperlink.openLink();
                        }
                    });
                }
                catch (ServiceException serviceException) {}
            } else {
                this.hyperlink.openLink();
            }
        }
    }
}

