/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.FixEdgeAnchorAfterCreationCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.FixEdgeAnchorsDeferredCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public class DefaultGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        EditPart targetEP;
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        View sourceView = (View)request.getSourceEditPart().getModel();
        createElementRequest.setParameter("SOURCE_GRAPHICAL_VIEW", (Object)sourceView);
        View targetView = (View)request.getTargetEditPart().getModel();
        createElementRequest.setParameter("TARGET_GRAPHICAL_VIEW", (Object)targetView);
        if (request.getLocation() != null) {
            createElementRequest.setParameter("EDGE_TARGET_POINT", (Object)request.getLocation().getCopy());
        } else {
            createElementRequest.setParameter("EDGE_TARGET_POINT", null);
        }
        EditPart sourceEP = request.getSourceEditPart();
        if (sourceEP instanceof GraphicalEditPart) {
            createElementRequest.setParameter("EDGE_SOURCE_FIGURE", (Object)((GraphicalEditPart)sourceEP).getFigure());
        }
        if ((targetEP = request.getTargetEditPart()) instanceof GraphicalEditPart) {
            createElementRequest.setParameter("EDGE_TARGET_FIGURE", (Object)((GraphicalEditPart)targetEP).getFigure());
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Command defaultCommand = super.getConnectionAndRelationshipCompleteCommand(request);
        if (defaultCommand != null && defaultCommand.canExecute()) {
            CompoundCommand cc = new CompoundCommand("ConnectionAndRelationshipCompleteCommand");
            cc.add(defaultCommand);
            FixEdgeAnchorAfterCreationCommand fixAnchor = new FixEdgeAnchorAfterCreationCommand(editingDomain, (CreateConnectionViewRequest)request);
            cc.add((Command)new ICommandProxy((ICommand)fixAnchor));
            return cc;
        }
        return defaultCommand;
    }

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        View sourceView;
        CreateRelationshipRequest createElementRequest;
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        if (requestAdapter != null && (createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class)) != null && request.getTargetEditPart() != null && (sourceView = (View)request.getTargetEditPart().getModel()) != null) {
            createElementRequest.setParameter("SOURCE_GRAPHICAL_VIEW", (Object)sourceView);
        }
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CreateViewCommand createCommand = new CreateViewCommand(editingDomain, (CreateViewRequest.ViewDescriptor)req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        Map parameters = req.getExtendedData();
        if (request.getLocation() != null) {
            parameters.put("EDGE_SOURCE_POINT", request.getLocation().getCopy());
        } else {
            parameters.put("EDGE_SOURCE_POINT", null);
        }
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Command reconnectCmd = super.getReconnectSourceCommand(request);
        if (reconnectCmd != null && reconnectCmd.canExecute()) {
            CompoundCommand cc = new CompoundCommand();
            cc.add(reconnectCmd);
            cc.add((Command)new ICommandProxy((ICommand)new FixEdgeAnchorsDeferredCommand(this.getEditingDomain(), (IGraphicalEditPart)this.getHost(), Collections.singleton(request.getConnectionEditPart()))));
            return cc;
        }
        return reconnectCmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command reconnectCmd = super.getReconnectTargetCommand(request);
        if (reconnectCmd != null && reconnectCmd.canExecute()) {
            CompoundCommand cc = new CompoundCommand();
            cc.add(reconnectCmd);
            cc.add((Command)new ICommandProxy((ICommand)new FixEdgeAnchorsDeferredCommand(this.getEditingDomain(), (IGraphicalEditPart)this.getHost(), Collections.singleton(request.getConnectionEditPart()))));
            return cc;
        }
        return reconnectCmd;
    }

    protected final TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(this.getHost());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }
}

