/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.assistants.codegen.internal.handlers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomBehaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddPopupBarEditPolicyHandler
extends AbstractHandler {
    static final String EDIT_POLICY_QNAME = "org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy";
    static final String EDIT_POLICY_KEY = String.valueOf(EditPolicyRoles.class.getName()) + ".POPUPBAR_ROLE";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList commands = Lists.newArrayList();
        IStructuredSelection sel = (IStructuredSelection)AdapterUtils.adapt((Object)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IStructuredSelection.class, null);
        if (sel != null) {
            EditingDomain domain = null;
            for (GenCompartment next : Iterables.filter((Iterable)sel.toList(), GenCompartment.class)) {
                if (domain == null) {
                    domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)next);
                }
                if (domain == null) continue;
                CustomBehaviour behaviour = this.getPopupBarBehaviour((GenCommonBase)next);
                if (behaviour != null) {
                    if (EDIT_POLICY_QNAME.equals(behaviour.getEditPolicyQualifiedClassName())) continue;
                    commands.add(SetCommand.create((EditingDomain)domain, (Object)behaviour, (Object)GMFGenPackage.eINSTANCE.getCustomBehaviour_EditPolicyQualifiedClassName(), (Object)EDIT_POLICY_QNAME));
                    continue;
                }
                behaviour = GMFGenFactory.eINSTANCE.createCustomBehaviour();
                behaviour.setKey(EDIT_POLICY_KEY);
                behaviour.setEditPolicyQualifiedClassName(EDIT_POLICY_QNAME);
                commands.add(AddCommand.create((EditingDomain)domain, (Object)next, (Object)GMFGenPackage.eINSTANCE.getGenCommonBase_Behaviour(), (Object)behaviour));
            }
            if (!commands.isEmpty()) {
                domain.getCommandStack().execute((Command)new CompoundCommand("Add Popup Bar Behavior", (List)commands));
            }
        }
        return null;
    }

    protected CustomBehaviour getPopupBarBehaviour(GenCommonBase genBase) {
        CustomBehaviour result = null;
        for (CustomBehaviour next : Iterables.filter((Iterable)genBase.getBehaviour(), CustomBehaviour.class)) {
            if (!EDIT_POLICY_KEY.equals(next.getKey())) continue;
            result = next;
            break;
        }
        return result;
    }
}

