/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.nodes.ConflictNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.nodes.DiffNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.nodes.MatchNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.nodes.MatchResourceNode;

public class DifferenceTreeBuilder
extends AdapterImpl {
    private Comparison comparison;

    public DifferenceTreeBuilder(Comparison comparison) {
        this.comparison = comparison;
    }

    public TreeNode buildMatchTree() {
        List<TreeNode> result = this.buildMatchTrees();
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    protected List<TreeNode> buildMatchTrees() {
        ArrayList<TreeNode> matchTrees = new ArrayList<TreeNode>();
        for (Match match : this.getComparison().getMatches()) {
            MatchNode matchNode = this.buildTree(match);
            if (matchNode == null) continue;
            matchTrees.add((TreeNode)matchNode);
        }
        return matchTrees;
    }

    private Comparison getComparison() {
        return this.comparison;
    }

    protected MatchNode buildTree(Match match) {
        MatchNode result = null;
        MatchNode matchNode = this.createMatchNode(match);
        this.populateMatchNode(matchNode);
        if (!matchNode.getChildren().isEmpty()) {
            result = matchNode;
        }
        return result;
    }

    protected void populateMatchNode(MatchNode matchNode) {
        Match match = matchNode.getMatch();
        LinkedHashMultimap diffsBySubMatch = LinkedHashMultimap.create();
        for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.alwaysTrue())) {
            if (!this.isPartOfLargerDiff(diff)) continue;
            Match targetMatch = this.getTargetMatch(diff);
            if (match == targetMatch) {
                this.addDiffNode(matchNode, diff);
                continue;
            }
            if (match.getSubmatches().contains((Object)targetMatch)) {
                diffsBySubMatch.put((Object)targetMatch, (Object)diff);
                continue;
            }
            if (targetMatch == null) continue;
            MatchNode targetMatchNode = this.createMatchNode(targetMatch);
            matchNode.addSubMatchNode(targetMatchNode);
            this.addDiffNode(targetMatchNode, diff);
        }
        for (Match subMatch : match.getSubmatches()) {
            MatchNode subMatchNode = this.createMatchNode(subMatch);
            for (Diff subMatchDiff : diffsBySubMatch.get((Object)subMatch)) {
                this.addDiffNode(subMatchNode, subMatchDiff);
            }
            diffsBySubMatch.removeAll((Object)subMatch);
            this.populateMatchNode(subMatchNode);
            if (subMatchNode.getChildren().isEmpty()) continue;
            matchNode.addSubMatchNode(subMatchNode);
        }
    }

    protected void addDiffNode(MatchNode matchNode, Diff diff) {
        if (!(diff instanceof ResourceAttachmentChange)) {
            DiffNode diffNode = this.createDiffNode(diff);
            this.handleRefiningDiffs(diffNode);
            matchNode.addDiffNode(diffNode);
        }
    }

    protected void handleRefiningDiffs(DiffNode diffNode) {
        Diff diff = diffNode.getDiff();
        for (Diff refiningDiff : diff.getRefinedBy()) {
            DiffNode refinedDiffNode = this.createDiffNode(refiningDiff);
            diffNode.addRefinedDiffNode(refinedDiffNode);
            this.handleRefiningDiffs(refinedDiffNode);
        }
    }

    protected boolean isPartOfLargerDiff(Diff diff) {
        return diff.getRefines().isEmpty();
    }

    protected Match getTargetMatch(Diff diff) {
        if (this.isPartOfLargerDiff(diff)) {
            if (this.isContainmentRefChange(diff)) {
                Match valueMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                return valueMatch;
            }
            if (this.isContainmentRefChange(diff.getPrimeRefining())) {
                Match valueMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff.getPrimeRefining()).getValue());
                return valueMatch;
            }
            return diff.getMatch();
        }
        return null;
    }

    protected boolean isContainmentRefChange(Diff diff) {
        return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
    }

    protected DiffNode createDiffNode(Diff diff) {
        DiffNode diffNode = new DiffNode(diff);
        diffNode.eAdapters().add((Object)this);
        return diffNode;
    }

    protected MatchNode createMatchNode(Match match) {
        MatchNode matchNode = new MatchNode(match);
        matchNode.eAdapters().add((Object)this);
        return matchNode;
    }

    protected ConflictNode createConflictNode(Conflict conflict) {
        ConflictNode conflictNode = new ConflictNode(conflict);
        conflictNode.eAdapters().add((Object)this);
        return conflictNode;
    }

    protected MatchResourceNode createMatchResourceNode(MatchResource matchResource) {
        MatchResourceNode matchResourceNode = new MatchResourceNode(matchResource);
        matchResourceNode.eAdapters().add((Object)this);
        return matchResourceNode;
    }
}

