/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.policy;

import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.EMFListener;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.internal.SyncService;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicyDelegate;

public abstract class SyncPolicyDelegate<M, T>
implements ISyncPolicyDelegate<M, T> {
    private EMFDispatchManager<EMFDispatch> dispatchManager;

    public void register(Class<?> syncFeatureType) {
        EMFListener listener = SyncService.getCurrent().register(this, syncFeatureType);
        this.dispatchManager = EMFDispatchManager.createSingle(listener);
    }

    public void deregister(Class<?> syncFeatureType) {
        if (this.dispatchManager != null) {
            this.dispatchManager.removeAll();
            this.dispatchManager = null;
        }
        SyncService.getCurrent().deregister(this, syncFeatureType);
    }

    @Override
    public void observe(SyncItem<M, T> syncTarget) {
        this.dispatchManager.add(syncTarget, this.createDispatcher(syncTarget));
    }

    @Override
    public void unobserve(SyncItem<M, T> syncTarget) {
        this.dispatchManager.remove(syncTarget);
    }

    protected abstract EMFDispatch createDispatcher(SyncItem<M, T> var1);
}

