/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkShell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Shell;

public class EditorHyperLinkWebShell
extends AbstractEditHyperlinkShell {
    protected static final String HYPERLINKS_LABEL = Messages.EditorHyperLinkWebShell_Hyperlinks;
    protected static final String HTTP = "http://";
    private HyperLinkWeb hyperLinkWeb = null;
    private boolean usedefaultTooltip = true;

    public EditorHyperLinkWebShell(Shell parentShell) {
        super(parentShell, false);
    }

    @Override
    protected void contentsCreated() {
        this.getObjectLabel().setText(HYPERLINKS_LABEL);
        this.updateFields();
        if (this.hyperLinkWeb != null) {
            this.getObjectLabelText().setText(this.hyperLinkWeb.getHyperLinkWeb());
            this.getTooltipInputText().setText(this.hyperLinkWeb.getTooltipText());
        } else {
            this.getObjectLabelText().setText(HTTP);
            this.getObjectLabelText().setSelection(HTTP.length());
        }
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        }
        this.getObjectLabelText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (EditorHyperLinkWebShell.this.usedefaultTooltip) {
                    EditorHyperLinkWebShell.this.getTooltipInputText().setText(EditorHyperLinkWebShell.this.getObjectLabelText().getText());
                }
            }
        });
    }

    @Override
    protected void onUseDefaultTooltip() {
        this.usedefaultTooltip = this.getUseDefaultCheckBox().getSelection();
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        } else {
            this.getTooltipInputText().setEditable(true);
        }
    }

    protected void cancelPressed() {
        this.hyperLinkWeb = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.hyperLinkWeb == null) {
            this.hyperLinkWeb = new HyperLinkWeb();
        }
        this.hyperLinkWeb.setHyperLinkWeb(this.getObjectLabelText().getText().trim());
        this.hyperLinkWeb.setTooltipText(this.getTooltipInputText().getText().trim());
        super.okPressed();
    }

    public HyperLinkWeb getHyperLinkWeb() {
        return this.hyperLinkWeb;
    }

    public void setHyperLinkWeb(HyperLinkWeb hyperLinkWeb) {
        this.hyperLinkWeb = hyperLinkWeb;
        this.updateFields();
    }

    private void updateFields() {
        if (this.hyperLinkWeb != null) {
            if (this.getObjectLabelText() != null) {
                this.getObjectLabelText().setText(this.hyperLinkWeb.getHyperLinkWeb());
            }
            if (this.getTooltipInputText() != null) {
                this.getTooltipInputText().setText(this.hyperLinkWeb.getTooltipText());
            }
        }
    }
}

