/**
 * Copyright (c) 2007, 2008, 2014, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - refactored javaInitilizers not to use methods from GMFGen model
 * 							[221347] Got rid of generated interfaces
 * 							(IObjectInitializer, IFeatureInitializer) and implementation thereof
 * Michael Golubev (Montages) - API extracted to GMF-T runtime, #386838 migrate to Xtend2
 * Christian W. Damus (CEA) - bug 440263
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt.providers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenReferenceNewElementSpec;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ElementInitializers_qvto {
  @Inject
  @Extension
  private Common _common;
  
  public List<Integer> newListAppending(final List<Integer> list, final int toAppend) {
    LinkedList<Integer> result = CollectionLiterals.<Integer>newLinkedList();
    result.addAll(list);
    result.add(Integer.valueOf(toAppend));
    return result;
  }
  
  protected boolean _expressionResultNeedsCast(final GenClassifier it) {
    return false;
  }
  
  protected boolean _expressionResultNeedsCast(final GenClass it) {
    return false;
  }
  
  protected boolean _expressionResultNeedsCast(final GenDataType it) {
    return (this.isNumberObject(it) || this.isPrimitiveNumberType(it));
  }
  
  protected boolean _expressionResultNeedsCast(final GenEnum it) {
    return true;
  }
  
  /**
   * Present approach may result in duplicated methods in few odd scenarios
   * when same feature gets initialized using java language inside single ElementInitializer hierarchy,
   * e.g. for a given diagram element, with feature1 and feature2 of a same/similar kind:
   * feature1
   * 	Instance1
   * 	 featureX
   * 		InstanceX1
   * 		 featureY = 'aaa' (Java)
   * feature2
   * 	Instance2
   * 	 featureX
   * 		InstanceX2
   * 		 featureY = 'bbb' (Java)
   * there would be two featureY_featureY_DiagramElement() methods
   */
  public String javaMethodName(final GenCommonBase de, final GenFeatureValueSpec valueSpec) {
    String middlePart = "";
    GenReferenceNewElementSpec _creatingInitializer = valueSpec.getFeatureSeqInitializer().getCreatingInitializer();
    boolean _tripleNotEquals = (_creatingInitializer != null);
    if (_tripleNotEquals) {
      String _name = valueSpec.getFeatureSeqInitializer().getCreatingInitializer().getFeature().getEcoreFeature().getName();
      String _plus = (_name + "_");
      middlePart = _plus;
    }
    String _name_1 = valueSpec.getFeature().getEcoreFeature().getName();
    String _plus_1 = (_name_1 + "_");
    String _plus_2 = (_plus_1 + middlePart);
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(de);
    return (_plus_2 + _stringUniqueIdentifier);
  }
  
  public Iterable<GenFeatureValueSpec> recurseCollectValueSpec(final GenFeatureSeqInitializer si) {
    return this.recurseCollectValueSpec(si, CollectionLiterals.<GenFeatureValueSpec>newLinkedHashSet());
  }
  
  public Iterable<GenFeatureValueSpec> recurseCollectValueSpec(final GenFeatureSeqInitializer si, final Collection<GenFeatureValueSpec> acc) {
    Iterables.<GenFeatureValueSpec>addAll(acc, Iterables.<GenFeatureValueSpec>filter(si.getInitializers(), GenFeatureValueSpec.class));
    Iterable<GenReferenceNewElementSpec> _filter = Iterables.<GenReferenceNewElementSpec>filter(si.getInitializers(), GenReferenceNewElementSpec.class);
    for (final GenReferenceNewElementSpec ref : _filter) {
      EList<GenFeatureSeqInitializer> _newElementInitializers = ref.getNewElementInitializers();
      for (final GenFeatureSeqInitializer featureSeqInit : _newElementInitializers) {
        this.recurseCollectValueSpec(featureSeqInit, acc);
      }
    }
    return acc;
  }
  
  public String getVariableName(final String prefix, final Iterable<Integer> suffixes) {
    String _combinedSuffix = this.combinedSuffix(suffixes);
    return (prefix + _combinedSuffix);
  }
  
  protected boolean _isNumberObject(final GenClassifier it) {
    return false;
  }
  
  protected boolean _isNumberObject(final GenClass it) {
    return false;
  }
  
  protected boolean _isNumberObject(final GenEnum it) {
    return false;
  }
  
  protected boolean _isNumberObject(final GenDataType it) {
    boolean _switchResult = false;
    String _instanceClassName = it.getEcoreDataType().getInstanceClassName();
    boolean _matched = false;
    if (Objects.equal(_instanceClassName, "java.math.BigDecimal")) {
      _matched=true;
      _switchResult = true;
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.math.BigInteger")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Byte")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Double")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Float")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Integer")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Long")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "java.lang.Short")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  protected boolean _isPrimitiveNumberType(final GenClassifier it) {
    return false;
  }
  
  protected boolean _isPrimitiveNumberType(final GenClass it) {
    return false;
  }
  
  protected boolean _isPrimitiveNumberType(final GenEnum it) {
    return false;
  }
  
  protected boolean _isPrimitiveNumberType(final GenDataType it) {
    boolean _switchResult = false;
    String _instanceClassName = it.getEcoreDataType().getInstanceClassName();
    boolean _matched = false;
    if (Objects.equal(_instanceClassName, "byte")) {
      _matched=true;
      _switchResult = true;
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "double")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "float")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "int")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "long")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      if (Objects.equal(_instanceClassName, "short")) {
        _matched=true;
        _switchResult = true;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public String combinedSuffix(final Iterable<Integer> suffixes) {
    String _join = IterableExtensions.join(suffixes, "_");
    return ("_" + _join);
  }
  
  public boolean expressionResultNeedsCast(final GenClassifier it) {
    if (it instanceof GenEnum) {
      return _expressionResultNeedsCast((GenEnum)it);
    } else if (it instanceof GenClass) {
      return _expressionResultNeedsCast((GenClass)it);
    } else if (it instanceof GenDataType) {
      return _expressionResultNeedsCast((GenDataType)it);
    } else if (it != null) {
      return _expressionResultNeedsCast(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  protected boolean isNumberObject(final GenClassifier it) {
    if (it instanceof GenEnum) {
      return _isNumberObject((GenEnum)it);
    } else if (it instanceof GenClass) {
      return _isNumberObject((GenClass)it);
    } else if (it instanceof GenDataType) {
      return _isNumberObject((GenDataType)it);
    } else if (it != null) {
      return _isNumberObject(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  protected boolean isPrimitiveNumberType(final GenClassifier it) {
    if (it instanceof GenEnum) {
      return _isPrimitiveNumberType((GenEnum)it);
    } else if (it instanceof GenClass) {
      return _isPrimitiveNumberType((GenClass)it);
    } else if (it instanceof GenDataType) {
      return _isPrimitiveNumberType((GenDataType)it);
    } else if (it != null) {
      return _isPrimitiveNumberType(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
