/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.application;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class Perspective {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private WorkbenchAdvisor xptWorkbenchAdvisor;
  
  public CharSequence className(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _perspectiveClassName = it.getPerspectiveClassName();
    _builder.append(_perspectiveClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Perspective(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" implements org.eclipse.ui.IPerspectiveFactory {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createInitialLayout = this.createInitialLayout(it);
    _builder.append(_createInitialLayout, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createInitialLayout(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void createInitialLayout(org.eclipse.ui.IPageLayout layout) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("layout.setEditorAreaVisible(true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("layout.addPerspectiveShortcut(");
    CharSequence _qualifiedClassName = this.xptWorkbenchAdvisor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".PERSPECTIVE_ID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IFolderLayout right = layout.createFolder(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("\"right\", org.eclipse.ui.IPageLayout.RIGHT, 0.6f, layout.getEditorArea()); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("right.addView(org.eclipse.ui.IPageLayout.ID_OUTLINE);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IFolderLayout bottomRight = layout.createFolder(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("\"bottomRight\", org.eclipse.ui.IPageLayout.BOTTOM, 0.6f, \"right\"); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t");
    _builder.append("\t ");
    CharSequence _nonNLS_2 = this._common.nonNLS(2);
    _builder.append(_nonNLS_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("bottomRight.addView(org.eclipse.ui.IPageLayout.ID_PROP_SHEET);");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _layoutAdditions = this.layoutAdditions(it);
    _builder.append(_layoutAdditions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence layoutAdditions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence additions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
