/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.validation;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IStereotypeOrphanGroup;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeApplicationRepairSnippet;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.papyrus.uml.modelrepair.ui.IZombieStereotypePresenter;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeApplicationRepairConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        ModelSet modelSet = this.getModelSetContext(ctx);
        if (modelSet != null) {
            return this.validate(ctx, modelSet);
        }
        return null;
    }

    protected IStatus validate(IValidationContext vctx, ModelSet modelSet) {
        IStatus result;
        ValidationPresenter presenter = new ValidationPresenter(vctx);
        StereotypeApplicationRepairSnippet repair = new StereotypeApplicationRepairSnippet((Function<? super ModelSet, ? extends IZombieStereotypePresenter>)Functions.constant((Object)presenter));
        repair.start(modelSet);
        try {
            result = presenter.aggregateResults();
        }
        finally {
            repair.dispose(modelSet);
        }
        return result;
    }

    protected ModelSet getModelSetContext(IValidationContext context) {
        EObject target;
        Resource.Internal resource;
        ModelSet result = null;
        if (context.getCurrentConstraintData() == null && (resource = ((InternalEObject)(target = context.getTarget())).eDirectResource()) != null && target instanceof Package && target.eContainer() == null && resource.getResourceSet() instanceof ModelSet) {
            result = (ModelSet)resource.getResourceSet();
            context.putCurrentConstraintData((Object)result);
        }
        return result;
    }

    private static final class ValidationPresenter
    implements IZombieStereotypePresenter {
        private final List<IConstraintStatus> problems = Lists.newArrayList();
        private final IValidationContext ctx;
        private final int severity;
        private final int statusCode;

        ValidationPresenter(IValidationContext ctx) {
            this.ctx = ctx;
            IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
            this.severity = desc.getSeverity().toIStatusSeverity();
            this.statusCode = desc.getStatusCode();
        }

        @Override
        public void dispose() {
        }

        @Override
        public Function<? super EPackage, Profile> getDynamicProfileSupplier() {
            return Functions.constant(null);
        }

        @Override
        public void addZombies(ZombieStereotypesDescriptor zombies) {
            for (IAdaptable iAdaptable : zombies.getZombieSchemas()) {
                Optional orphans = AdapterUtils.adapt((Object)iAdaptable, IStereotypeOrphanGroup.class);
                if (orphans.isPresent()) {
                    this.reportOrphans(zombies.getZombies(iAdaptable));
                    continue;
                }
                this.reportBroken(zombies.getZombies(iAdaptable));
            }
        }

        protected void reportOrphans(Iterable<? extends EObject> stereotypes) {
            for (EObject eObject : stereotypes) {
                Stereotype stereotype = UMLUtil.getStereotype((EObject)eObject);
                String name = stereotype == null ? eObject.eClass().getName() : stereotype.getName();
                this.problems.add((IConstraintStatus)ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)eObject, null, (int)this.severity, (int)this.statusCode, (String)"Stereotype \"{0}\" application is detached from its base UML element.", (Object[])new Object[]{name}));
            }
        }

        protected void reportBroken(Iterable<? extends EObject> stereotypes) {
            for (EObject eObject : stereotypes) {
                String name = eObject.eClass().getName();
                this.problems.add((IConstraintStatus)ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)eObject, null, (int)this.severity, (int)this.statusCode, (String)"Stereotype \"{0}\" application is inconsistent with applied profile(s).", (Object[])new Object[]{name}));
            }
        }

        @Override
        public void asyncAddZombies(Runnable runnable) {
            runnable.run();
        }

        @Override
        public boolean isPending() {
            return false;
        }

        @Override
        public void awaitPending(boolean expected) throws InterruptedException {
        }

        @Override
        public void onPendingDone(Runnable runnable) {
            runnable.run();
        }

        IStatus aggregateResults() {
            return this.problems.isEmpty() ? null : ConstraintStatus.createMultiStatus((IValidationContext)this.ctx, this.problems);
        }
    }
}

