/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.navigator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public int getMaxVisualID(final GenNavigator navigator) {
    final Function1<GenCommonBase, Integer> _function = new Function1<GenCommonBase, Integer>() {
      @Override
      public Integer apply(final GenCommonBase n) {
        return Integer.valueOf(n.getVisualID());
      }
    };
    return IterableExtensions.<GenCommonBase>last(IterableExtensions.<GenCommonBase, Integer>sortBy(this.getNavigatorNodes(navigator), _function)).getVisualID();
  }
  
  public Iterable<GenCommonBase> getNavigatorContainerNodes(final GenNavigator navigator) {
    final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
      @Override
      public Boolean apply(final GenCommonBase n) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenNavigatorChildReference>notEmpty(Utils_qvto.this.getChildReferencesFrom(navigator, n)));
      }
    };
    return IterableExtensions.<GenCommonBase>filter(this.getNavigatorNodes(navigator), _function);
  }
  
  public Iterable<GenCommonBase> getNavigatorContainedNodes(final GenNavigator navigator) {
    final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
      @Override
      public Boolean apply(final GenCommonBase n) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenNavigatorChildReference>notEmpty(Utils_qvto.this.getChildReferencesTo(navigator, n)));
      }
    };
    return IterableExtensions.<GenCommonBase>filter(this.getNavigatorNodes(navigator), _function);
  }
  
  public Iterable<GenCommonBase> getNavigatorNodes(final GenNavigator navigator) {
    LinkedList<GenCommonBase> result = CollectionLiterals.<GenCommonBase>newLinkedList();
    result.addAll(navigator.getEditorGen().getDiagram().getAllContainers());
    result.addAll(navigator.getEditorGen().getDiagram().getLinks());
    final Function1<GenCommonBase, Integer> _function = new Function1<GenCommonBase, Integer>() {
      @Override
      public Integer apply(final GenCommonBase n) {
        return Integer.valueOf(n.getVisualID());
      }
    };
    return IterableExtensions.<GenCommonBase, Integer>sortBy(result, _function);
  }
  
  public Set<String> getGroupNames(final Iterable<GenNavigatorChildReference> refs) {
    final Function1<GenNavigatorChildReference, Boolean> _function = new Function1<GenNavigatorChildReference, Boolean>() {
      @Override
      public Boolean apply(final GenNavigatorChildReference ref) {
        return Boolean.valueOf(ref.isInsideGroup());
      }
    };
    final Function1<GenNavigatorChildReference, String> _function_1 = new Function1<GenNavigatorChildReference, String>() {
      @Override
      public String apply(final GenNavigatorChildReference ref) {
        return ref.getGroupName();
      }
    };
    return IterableExtensions.<String>toSet(IterableExtensions.<GenNavigatorChildReference, String>map(IterableExtensions.<GenNavigatorChildReference>filter(refs, _function), _function_1));
  }
  
  public GenNavigatorChildReference getNavigatorReference(final String groupName, final Iterable<GenNavigatorChildReference> childReferences) {
    final Function1<GenNavigatorChildReference, Boolean> _function = new Function1<GenNavigatorChildReference, Boolean>() {
      @Override
      public Boolean apply(final GenNavigatorChildReference r) {
        String _groupName = r.getGroupName();
        return Boolean.valueOf(Objects.equal(_groupName, groupName));
      }
    };
    return IterableExtensions.<GenNavigatorChildReference>findFirst(childReferences, _function);
  }
  
  public Iterable<GenNavigatorChildReference> getChildReferencesFrom(final GenNavigator navigator, final GenCommonBase parent) {
    Iterable<GenNavigatorChildReference> _xifexpression = null;
    if ((parent == null)) {
      final Function1<GenNavigatorChildReference, Boolean> _function = new Function1<GenNavigatorChildReference, Boolean>() {
        @Override
        public Boolean apply(final GenNavigatorChildReference r) {
          GenCommonBase _parent = r.getParent();
          return Boolean.valueOf((_parent == null));
        }
      };
      _xifexpression = IterableExtensions.<GenNavigatorChildReference>filter(navigator.getChildReferences(), _function);
    } else {
      final Function1<GenNavigatorChildReference, Boolean> _function_1 = new Function1<GenNavigatorChildReference, Boolean>() {
        @Override
        public Boolean apply(final GenNavigatorChildReference r) {
          return Boolean.valueOf(((r.getParent() != null) && (parent.getVisualID() == r.getParent().getVisualID())));
        }
      };
      _xifexpression = IterableExtensions.<GenNavigatorChildReference>filter(navigator.getChildReferences(), _function_1);
    }
    return _xifexpression;
  }
  
  public Iterable<GenNavigatorChildReference> getChildReferencesTo(final GenNavigator navigator, final GenCommonBase child) {
    final Function1<GenNavigatorChildReference, Boolean> _function = new Function1<GenNavigatorChildReference, Boolean>() {
      @Override
      public Boolean apply(final GenNavigatorChildReference r) {
        int _visualID = child.getVisualID();
        int _visualID_1 = r.getChild().getVisualID();
        return Boolean.valueOf((_visualID == _visualID_1));
      }
    };
    return IterableExtensions.<GenNavigatorChildReference>filter(navigator.getChildReferences(), _function);
  }
  
  public GenNavigatorChildReference getDiagramTopReference(final GenNavigator navigator) {
    final Function1<GenNavigatorChildReference, Boolean> _function = new Function1<GenNavigatorChildReference, Boolean>() {
      @Override
      public Boolean apply(final GenNavigatorChildReference cr) {
        GenCommonBase _parent = cr.getParent();
        return Boolean.valueOf((null == _parent));
      }
    };
    final Function1<GenNavigatorChildReference, Boolean> _function_1 = new Function1<GenNavigatorChildReference, Boolean>() {
      @Override
      public Boolean apply(final GenNavigatorChildReference cr) {
        GenCommonBase _child = cr.getChild();
        GenDiagram _diagram = navigator.getEditorGen().getDiagram();
        return Boolean.valueOf(Objects.equal(_child, _diagram));
      }
    };
    return IterableExtensions.<GenNavigatorChildReference>head(IterableExtensions.<GenNavigatorChildReference>filter(IterableExtensions.<GenNavigatorChildReference>filter(navigator.getChildReferences(), _function), _function_1));
  }
  
  public boolean isStringFeature(final GenFeature feature) {
    String _name = feature.getEcoreFeature().getEType().getName();
    return Objects.equal(_name, "EString");
  }
}
