/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.config.utils.CellEditorConfigurationUtils;
import org.eclipse.papyrus.uml.nattable.editor.MultiEnumCellEditor;

public class MultiEEnumCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.MultiEEnumCellEditorConfiguration.MultiEditor";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a multi editor for a multi EEnum type";
    }

    public boolean handles(Table table, Object axisElement) {
        EStructuralFeature feature;
        boolean result = false;
        Object representedElement = AxisUtils.getRepresentedElement((Object)axisElement);
        if (representedElement instanceof EStructuralFeature && (feature = (EStructuralFeature)representedElement).isMany()) {
            EClassifier eType = feature.getEType();
            result = eType instanceof EEnum;
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        CellEditorConfigurationUtils.configureCellPainter(configRegistry, axis, configLabel);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new MultiEnumCellEditor(axisElement, modelManager.getTableAxisElementProvider()), "EDIT", configLabel);
    }
}

